/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_AnalogEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_ANALOGENTITY_CCA_H__
#define __AUTOGEN_ANALOGENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup AnalogEntity Analog Entity
/// AnalogClass:
/// Interface to analog entities on BrainStem modules.
/// Analog entities may be configured as a input or output depending
/// on hardware capabilities. Some modules are capable of providing actual
/// voltage readings, while other simply return the raw analog-to-digital converter (ADC)
/// output value. The resolution of the voltage or number of useful bits is also
/// hardware dependent.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the raw ADC output value in bits.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    16 bit analog reading with 0 corresponding to the negative
///    analog voltage reference and
///    0xFFFF corresponding to the positive analog voltage reference.
///    \note Not all modules are provide 16 useful bits; this value's least
///    significant bits are zero-padded to 16 bits. Refer to the module's
///    datasheet to determine analog bit depth and reference voltage.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_getValue ( unsigned int* id, struct Result* result, const int index );

/// Get the scaled micro volt value with reference to ground.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    32 bit signed integer (in microvolts) based on the board's
///    ground and reference voltages.
///    \note Not all modules provide 32 bits of accuracy; Refer to the module's
///    datasheet to determine the analog bit depth and reference voltage.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_getVoltage ( unsigned int* id, struct Result* result, const int index );

/// Get the analog input range.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    8 bit value corresponding to a discrete range option
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_getRange ( unsigned int* id, struct Result* result, const int index );

/// Get the analog output enable status.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    0 if disabled 1 if enabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_getEnable ( unsigned int* id, struct Result* result, const int index );

/// Set the value of an analog output (DAC) in bits.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param value 16 bit analog set point with 0 corresponding to the negative
/// analog voltage reference  and
/// 0xFFFF corresponding to the positive analog voltage reference.
/// \note Not all modules are provide 16 useful bits; the least significant bits
/// are discarded. E.g. for a 10 bit DAC, 0xFFC0 to 0x0040 is the useful range.
/// Refer to the module's
/// datasheet to determine analog bit depth and reference voltage.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_setValue ( unsigned int* id, struct Result* result, const int index, const unsigned short value );

/// Set the voltage level of an analog output (DAC) in microvolts.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param microvolts 32 bit signed integer (in microvolts) based
/// on the board's ground and reference voltages.
/// \note Voltage range is dependent on the specific DAC channel
/// range.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_setVoltage ( unsigned int* id, struct Result* result, const int index, const int microvolts );

/// Set the analog input range.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param range 8 bit value corresponding to a discrete range option
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_setRange ( unsigned int* id, struct Result* result, const int index, const unsigned char range );

/// Set the analog output enable state.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable set 1 to enable or 0 to disable.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_setEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Set the analog configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param configuration - bitAnalogConfigurationOutput configures the
///                        analog entity as an output.
/// \details EntityReturnValues "common entity" return values
/// \details aErrConfiguration - Entity does not support this configuration.
aLIBEXPORT void __stdcall analog_setConfiguration ( unsigned int* id, struct Result* result, const int index, const unsigned char configuration );

/// Get the analog configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    - Current configuration of the analog entity.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_getConfiguration ( unsigned int* id, struct Result* result, const int index );

/// Set the sample rate for this analog when bulk capturing.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param value sample rate in samples per second (Hertz).
/// Minimum rate: 7,000 Hz
/// Maximum rate: 200,000 Hz
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_setBulkCaptureSampleRate ( unsigned int* id, struct Result* result, const int index, const unsigned int value );

/// Get the current sample rate setting for this analog when bulk capturing.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    upon success filled with current sample rate in samples per second (Hertz).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_getBulkCaptureSampleRate ( unsigned int* id, struct Result* result, const int index );

/// Set the number of samples to capture for this analog when bulk capturing.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param value number of samples.
/// Minimum # of Samples: 0
/// Maximum # of Samples: (BRAINSTEM_RAM_SLOT_SIZE / 2) = (3FFF / 2) = 1FFF = 8191
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_setBulkCaptureNumberOfSamples ( unsigned int* id, struct Result* result, const int index, const unsigned int value );

/// Get the current number of samples setting for this analog when bulk capturing.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    number of samples.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_getBulkCaptureNumberOfSamples ( unsigned int* id, struct Result* result, const int index );

/// Initiate a BulkCapture on this analog. Captured measurements are stored in the
/// module's RAM store (RAM_STORE) slot 0. Data is stored in a contiguous byte array
/// with each sample stored in two consecutive bytes, LSB first.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values. When the
/// bulk capture is complete getBulkCaptureState() will return either
/// bulkCaptureFinished or bulkCaptureError.
aLIBEXPORT void __stdcall analog_initiateBulkCapture ( unsigned int* id, struct Result* result, const int index );

/// Get the current bulk capture state for this analog.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    the state of bulk capture.
///    - Idle: bulkCaptureIdle = 0
///    - Pending: bulkCapturePending = 1
///    - Finished: bulkCaptureFinished = 2
///    - Error: bulkCaptureError = 3
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall analog_getBulkCaptureState ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif