/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_DigitalEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_DIGITALENTITY_CCA_H__
#define __AUTOGEN_DIGITALENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup DigitalEntity Digital Entity
/// DigitalClass:
/// Interface to digital entities on BrainStem modules.
/// Digital entities have the following 5 possibilities: Digital Input,
/// Digital Output, RCServo Input, RCServo Output, and HighZ.
/// Other capabilities may be available and not all pins support all
/// configurations. Please see the product datasheet.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Set the digital configuration to one of the available 5 states.
/// Note: Some configurations are only supported on specific pins.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param configuration The configuration to be applied
/// - Digital Input: digitalConfigurationInput = 0
/// - Digital Output: digitalConfigurationOutput = 1
/// - RCServo Input: digitalConfigurationRCServoInput = 2
/// - RCServo Output: digitalConfigurationRCServoOutput = 3
/// - High Z State: digitalConfigurationHiZ = 4
/// - Digital Input: digitalConfigurationInputPullUp = 0
/// - Digital Input: digitalConfigurationInputNoPull = 4
/// - Digital Input: digitalConfigurationInputPullDown = 5
/// \details Returns \ref EntityReturnValues "common entity" return values
/// \details aErrConfiguration Entity does not support this configuration.
aLIBEXPORT void __stdcall digital_setConfiguration ( unsigned int* id, struct Result* result, const int index, const unsigned char configuration );

/// Get the digital configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    - Current configuration of the digital entity.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall digital_getConfiguration ( unsigned int* id, struct Result* result, const int index );

/// Set the logical state.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param state The state to be set. 0 is logic low, 1 is logic high.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall digital_setState ( unsigned int* id, struct Result* result, const int index, const unsigned char state );

/// Get the state.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current state of the digital entity. 0 is logic low,
///    1 is logic high. Note: If in high Z state an error will be returned.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall digital_getState ( unsigned int* id, struct Result* result, const int index );

/// Sets the logical state of all available digitals based on the bit mapping.
/// Number of digitals varies across BrainStem modules.  Refer
/// to the datasheet for the capabilities  of your module.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param state The state to be set for all digitals in a bit mapped representation.
/// 0 is logic low, 1 is logic high. Where bit 0 = digital 0, bit 1 = digital 1 etc.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall digital_setStateAll ( unsigned int* id, struct Result* result, const int index, const unsigned int state );

/// Gets the logical state of all available digitals in a bit mapped representation.
/// Number of digitals varies across BrainStem modules.  Refer
/// to the datasheet for the capabilities  of your module.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The state of all digitals where bit 0 = digital 0,
///    bit 1 = digital 1 etc. 0 is logic low, 1 is logic high.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall digital_getStateAll ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif