/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_EqualizerEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_EQUALIZERENTITY_CCA_H__
#define __AUTOGEN_EQUALIZERENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup EqualizerEntity Equalizer Entity
/// EqualizerClass:
/// Provides receiver and transmitter gain/boost/emphasis
/// settings for some of Acroname's products.  Please see product
/// documentation for further details.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Sets the receiver configuration for a given channel.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param channel The equalizer receiver channel.
/// \param config Configuration to be applied to the receiver.
/// \details Returns \ref EntityReturnValues "common entity" return values.
aLIBEXPORT void __stdcall equalizer_setReceiverConfig ( unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned char config );

/// Gets the receiver configuration for a given channel.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Configuration of the receiver.
/// \param index The index of the entity in question.
/// \param channel The equalizer receiver channel.
/// \details Returns \ref EntityReturnValues "common entity" return values.
aLIBEXPORT void __stdcall equalizer_getReceiverConfig ( unsigned int* id, struct Result* result, const int index, const unsigned char channel );

/// Sets the transmitter configuration
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param config Configuration to be applied to the transmitter.
/// \details Returns \ref EntityReturnValues "common entity" return values.
aLIBEXPORT void __stdcall equalizer_setTransmitterConfig ( unsigned int* id, struct Result* result, const int index, const unsigned char config );

/// Gets the transmitter configuration
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Configuration of the Transmitter.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values.
aLIBEXPORT void __stdcall equalizer_getTransmitterConfig ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif