/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_MuxEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_MUXENTITY_CCA_H__
#define __AUTOGEN_MUXENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup MuxEntity Mux Entity
/// MuxClass:
/// A MUX is a multiplexer that takes one or more similar inputs
/// (bus, connection, or signal) and allows switching to one or more outputs.
/// An analogy would be the switchboard of a telephone operator.  Calls (inputs)
/// come in and by re-connecting the input to an output, the operator
/// (multiplexer) can direct that input to on or more outputs.
///
/// One possible output is to not connect the input to anything which
/// essentially disables that input's connection to anything.
///
/// Not every MUX has multiple inputs.  Some may simply be a single input that
/// can be enabled (connected to a single output) or disabled
/// (not connected to anything).
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the mux enable/disable status
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    true: mux is enabled, false: the mux is disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_getEnable ( unsigned int* id, struct Result* result, const int index );

/// Enable the mux.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param bEnable true: enables the mux for the selected channel.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_setEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char bEnable );

/// Get the current selected mux channel.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Indicates which chanel is selected.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_getChannel ( unsigned int* id, struct Result* result, const int index );

/// Set the current mux channel.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param channel mux channel to select.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_setChannel ( unsigned int* id, struct Result* result, const int index, const unsigned char channel );

/// Get the voltage of the indicated mux channel.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    32 bit signed integer (in microvolts) based on the board's
///    ground and reference voltages.
///    \note Not all modules provide 32 bits of accuracy; Refer to the module's
///    datasheet to determine the analog bit depth and reference voltage.
/// \param index The index of the entity in question.
/// \param channel The channel in which voltage was requested.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_getChannelVoltage ( unsigned int* id, struct Result* result, const int index, const unsigned char channel );

/// Get the configuration of the mux.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    integer representing the mux configuration either default, or split-mode.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_getConfiguration ( unsigned int* id, struct Result* result, const int index );

/// Set the configuration of the mux.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param config integer representing the mux configuration either muxConfig_default, or muxConfig_splitMode.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_setConfiguration ( unsigned int* id, struct Result* result, const int index, const int config );

/// Get the current split mode mux configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    integer representing the channel selection for
///    each sub-channel within the mux. See the data-sheet for the device
///    for specific information.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_getSplitMode ( unsigned int* id, struct Result* result, const int index );

/// Sets the mux's split mode configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param splitMode integer representing the channel selection for
/// each sub-channel within the mux. See the data-sheet for the device
/// for specific information.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall mux_setSplitMode ( unsigned int* id, struct Result* result, const int index, const int splitMode );


#ifdef __cplusplus
}
#endif

#endif