/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_PortEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_PORTENTITY_CCA_H__
#define __AUTOGEN_PORTENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup PortEntity Port Entity
/// Port Class:
/// The Port Entity provides software control over the most basic items related to a
/// USB Port. This includes everything from the complete enable and disable of the
/// entire port to the individual control of specific pins. Voltage and Current
/// measurements are also included for devices which support the Port Entity.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Gets the Vbus Voltage
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The voltage in microvolts (1 == 1e-6V) currently present on Vbus.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVbusVoltage ( unsigned int* id, struct Result* result, const int index );

/// Gets the Vbus Current
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current in microamps (1 == 1e-6A) currently present on Vbus.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVbusCurrent ( unsigned int* id, struct Result* result, const int index );

/// Gets the Vconn Voltage
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The voltage in microvolts (1 == 1e-6V) currently present on Vconn.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVconnVoltage ( unsigned int* id, struct Result* result, const int index );

/// Gets the Vconn Current
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current in microamps (1 == 1e-6A) currently present on Vconn.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVconnCurrent ( unsigned int* id, struct Result* result, const int index );

/// Gets the Port Power Mode: Convenience Function of get/setPortMode
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current power mode.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getPowerMode ( unsigned int* id, struct Result* result, const int index );

/// Sets the Port Power Mode: Convenience Function of get/setPortMode
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param powerMode The power mode to be set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setPowerMode ( unsigned int* id, struct Result* result, const int index, const unsigned char powerMode );

/// Gets the current enable value of the port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Fully enabled port; 0 = One or more disabled components.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getEnabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the entire port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Fully enable port; 0 = Fully disable port.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the data lines.: Sub-component (Data) of getEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Data enabled; 0 = Data disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataEnabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the data lines. Sub-component (Data) of setEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable data; 0 = Disable data.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the High Speed (HS) data lines.
/// Sub-component of getDataEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Data enabled; 0 = Data disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataHSEnabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the High Speed (HS) data lines.
/// Sub-component of setDataEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable data; 0 = Disable data.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataHSEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the High Speed A side (HSA) data lines.:
/// Sub-component of getDataHSEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Data enabled; 0 = Data disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataHS1Enabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the Hight Speed A side (HSA) data lines.
/// Sub-component of setDataHSEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable data; 0 = Disable data.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataHS1Enabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the High Speed B side (HSB) data lines.:
/// Sub-component of getDataHSEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Data enabled; 0 = Data disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataHS2Enabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the Hight Speed B side (HSB) data lines.
/// Sub-component of setDataHSEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable data; 0 = Disable data.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataHS2Enabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the Super Speed (SS) data lines.
/// Sub-component of getDataEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Data enabled; 0 = Data disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataSSEnabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the Super Speed (SS) data lines.
/// Sub-component of setDataEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable data; 0 = Disable data.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataSSEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the Super Speed A side (SSA) data lines.:
/// Sub-component of getDataSSEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Data enabled; 0 = Data disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataSS1Enabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the Super Speed (SS) data lines.
/// Sub-component of setDataEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable data; 0 = Disable data.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataSS1Enabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the Super Speed B side (SSB) data lines.:
/// Sub-component of getDataSSEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Data enabled; 0 = Data disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataSS2Enabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the Super Speed B side (SSB) data lines.
/// Sub-component of setDataSSEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable data; 0 = Disable data.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataSS2Enabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the power lines.: Sub-component (Power) of getEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Power enabled; 0 = Power disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getPowerEnabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or Disables the power lines. Sub-component (Power) of setEnable.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable power; 0 = Disable disable.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setPowerEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the Port Data Role.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The data role to be set. See datasheet for details.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataRole ( unsigned int* id, struct Result* result, const int index );

/// Gets the current enable value of the Vconn lines.: Sub-component (Vconn) of getEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Vconn enabled; 0 = Vconn disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVconnEnabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the Vconn lines. Sub-component (Vconn) of setEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable Vconn lines; 0 = Disable Vconn lines.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setVconnEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the Vconn1 lines. Sub-component of getVconnEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Vconn1 enabled; 0 = Vconn1 disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVconn1Enabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the Vconn1 lines. Sub-component of setVconnEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable Vconn1 lines; 0 = Disable Vconn1 lines.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setVconn1Enabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the Vconn2 lines. Sub-component of getVconnEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Vconn2 enabled; 0 = Vconn2 disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVconn2Enabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the Vconn2 lines. Sub-component of setVconnEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable Vconn2 lines; 0 = Disable Vconn2 lines.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setVconn2Enabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the CC lines.: Sub-component (CC) of getEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = CC enabled; 0 = CC disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getCCEnabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the CC lines. Sub-component (CC) of setEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable CC lines; 0 = Disable CC lines.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setCCEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the CC1 lines. Sub-component of getCCEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = CC1 enabled; 0 = CC1 disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getCC1Enabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the CC1 lines. Sub-component of setCCEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable CC1 lines; 0 = Disable CC1 lines.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setCC1Enabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current enable value of the CC2 lines. Sub-component of getCCEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = CC2 enabled; 0 = CC2 disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getCC2Enabled ( unsigned int* id, struct Result* result, const int index );

/// Enables or disables the CC2 lines. Sub-component of setCCEnabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable 1 = Enable CC2 lines; 0 = Disable CC2 lines.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setCC2Enabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Gets the current voltage setpoint value for the port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    the voltage setpoint of the port in uV.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVoltageSetpoint ( unsigned int* id, struct Result* result, const int index );

/// Sets the current voltage setpoint value for the port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param value the voltage setpoint of the port in uV.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setVoltageSetpoint ( unsigned int* id, struct Result* result, const int index, const unsigned int value );

/// A bit mapped representation of the current state of the port.
/// Reflects what he port IS which may differ from what was requested.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the current state.
/// \param index The index of the entity in question.
aLIBEXPORT void __stdcall port_getState ( unsigned int* id, struct Result* result, const int index );

/// Gets the speed of the enumerated device.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Bit mapped value representing the devices speed.
///    See "Devices" reference for details.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataSpeed ( unsigned int* id, struct Result* result, const int index );

/// Gets current mode of the port
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Bit mapped value representing the ports mode.
///    See "Devices" reference for details.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getMode ( unsigned int* id, struct Result* result, const int index );

/// Sets the mode of the port
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param mode Port mode to be set. See "Devices" documentation
/// for details.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setMode ( unsigned int* id, struct Result* result, const int index, const unsigned int mode );

/// Returns any errors that are present on the port.
/// Calling this function will clear the current errors. If the error persists it will be set again.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Bit mapped field representing the current errors of the ports
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getErrors ( unsigned int* id, struct Result* result, const int index );

/// Gets the current limit of the port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the limit in microAmps (uA).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getCurrentLimit ( unsigned int* id, struct Result* result, const int index );

/// Sets the current limit of the port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param limit  Current limit to be applied in microAmps (uA).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setCurrentLimit ( unsigned int* id, struct Result* result, const int index, const unsigned int limit );

/// Gets the current limit mode.
/// The mode determines how the port will react to an over current condition.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of the current limit mode.
///    Available modes are product specific. See the reference documentation.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getCurrentLimitMode ( unsigned int* id, struct Result* result, const int index );

/// Sets the current limit mode.
/// The mode determines how the port will react to an over current condition.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param mode An enumerated representation of the current limit mode.
/// Available modes are product specific. See the reference documentation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setCurrentLimitMode ( unsigned int* id, struct Result* result, const int index, const unsigned char mode );

/// Gets the current available power.
/// This value is determined by the power manager which is responsible for budgeting the
/// systems available power envelope.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the available power in milli-watts (mW).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getAvailablePower ( unsigned int* id, struct Result* result, const int index );

/// Gets the currently allocated power
/// This value is determined by the power manager which is responsible for budgeting the
/// systems available power envelope.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the allocated power in milli-watts (mW).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getAllocatedPower ( unsigned int* id, struct Result* result, const int index );

/// Gets the user defined power limit for the port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the power limit in milli-watts (mW).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getPowerLimit ( unsigned int* id, struct Result* result, const int index );

/// Sets a user defined power limit for the port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param limit Power limit to be applied in milli-watts (mW).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setPowerLimit ( unsigned int* id, struct Result* result, const int index, const unsigned int limit );

/// Gets the power limit mode.
/// The mode determines how the port will react to an over power condition.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of the power limit mode.
///    Available modes are product specific. See the reference documentation.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getPowerLimitMode ( unsigned int* id, struct Result* result, const int index );

/// Sets the power limit mode.
/// The mode determines how the port will react to an over power condition.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param mode An enumerated representation of the power limit mode to be applied
/// Available modes are product specific. See the reference documentation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setPowerLimitMode ( unsigned int* id, struct Result* result, const int index, const unsigned char mode );

/// Gets a user defined name of the port.
/// Helpful for identifying ports/devices in a static environment.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getName ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, const unsigned int bufferLength );

/// Sets a user defined name of the port.
/// Helpful for identifying ports/devices in a static environment.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param buffer Pointer to the start of a c style buffer to be transferred.
/// \param bufferLength Length of the buffer to be transferred.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setName ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, const unsigned int bufferLength );

/// Gets the CC Current Limit Resistance
/// The CC Current limit is the value that's set for the pull up resistance
/// on the CC lines for basic USB-C negotations.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of the CC Current limit.
///    0 = None, 1 = Default (500/900mA), 2 = 1.5A, and 3 = 3.0A
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getCCCurrentLimit ( unsigned int* id, struct Result* result, const int index );

/// Sets the CC Current Limit Resistance
/// The CC Current limit is the value that's set for the pull up resistance
/// on the CC lines for basic USB-C negotations.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param value Variable to be filled with an enumerated representation of the CC Current limit.
/// 0 = None, 1 = Default (500/900mA), 2 = 1.5A, and 3 = 3.0A
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setCCCurrentLimit ( unsigned int* id, struct Result* result, const int index, const unsigned char value );

/// Gets the HighSpeed Data Routing Behavior.
/// The mode determines how the port will route the data lines.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of the routing behavior.
///    Available modes are product specific. See the reference documentation.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataHSRoutingBehavior ( unsigned int* id, struct Result* result, const int index );

/// Sets the HighSpeed Data Routing Behavior.
/// The mode determines how the port will route the data lines.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param mode An enumerated representation of the routing behavior.
/// Available modes are product specific. See the reference documentation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataHSRoutingBehavior ( unsigned int* id, struct Result* result, const int index, const unsigned char mode );

/// Gets the SuperSpeed Data Routing Behavior.
/// The mode determines how the port will route the data lines.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of the routing behavior.
///    Available modes are product specific. See the reference documentation.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getDataSSRoutingBehavior ( unsigned int* id, struct Result* result, const int index );

/// Sets the SuperSpeed Data Routing Behavior.
/// The mode determines how the port will route the data lines.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param mode An enumerated representation of the routing behavior.
/// Available modes are product specific. See the reference documentation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setDataSSRoutingBehavior ( unsigned int* id, struct Result* result, const int index, const unsigned char mode );

/// Gets the Vbus Accumulated Power
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The accumuled power on Vbus in milliwatt-hours.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVbusAccumulatedPower ( unsigned int* id, struct Result* result, const int index );

/// Resets the Vbus Accumulated Power to zero.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_resetVbusAccumulatedPower ( unsigned int* id, struct Result* result, const int index );

/// Gets the Vconn Accumulated Power
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The accumuled power on Vconn in milliwatt-hours.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getVconnAccumulatedPower ( unsigned int* id, struct Result* result, const int index );

/// Resets the Vconn Accumulated Power to zero.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_resetVconnAccumulatedPower ( unsigned int* id, struct Result* result, const int index );

/// Sets the ports USB 2.0 High Speed Boost Settings
/// The setting determines how much additional drive the USB 2.0 signal
/// will have in High Speed mode.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param boost An enumerated representation of the boost range.
/// Available value are product specific. See the reference documentation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_setHSBoost ( unsigned int* id, struct Result* result, const int index, const unsigned char boost );

/// Gets the ports USB 2.0 High Speed Boost Settings
/// The setting determines how much additional drive the USB 2.0 signal
/// will have in High Speed mode.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    An enumerated representation of the boost range.
///    Available modes are product specific. See the reference documentation.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getHSBoost ( unsigned int* id, struct Result* result, const int index );

/// Resets the PortClass Entity to it factory default configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_resetEntityToFactoryDefaults ( unsigned int* id, struct Result* result, const int index );

/// Gets the current CC1 Strapping on local and remote
/// The state is a bit packed value where the upper byte is used to represent
/// the remote or partner device attached to the ports resistance and the
/// lower byte is used to represent the local or hubs resistance.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an packed enumerated representation of the CC state.
///    Enumeration values for each byte are as follows:
///    - None = 0 = portCC1State_None
///    - Invalid = 1 = portCC1State_Invalid
///    - Rp (default) = 2 = portCC1State_RpDefault
///    - Rp (1.5A) = 3 = portCC1State_Rp1p5
///    - Rp (3A) = 4 = portCC1State_Rp3p0
///    - Rd = 5 = portCC1State_Rd
///    - Ra = 6 = portCC1State_Ra
///    - Managed by controller = 7 = portCC1State_Managed
///    - Unknown = 8 = portCC1State_Unknown
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getCC1State ( unsigned int* id, struct Result* result, const int index );

/// Gets the current CC2 Strapping on local and remote
/// The state is a bit packed value where the upper byte is used to represent
/// the remote or partner device attached to the ports resistance and the
/// lower byte is used to represent the local or hubs resistance.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an packed enumerated representation of the CC state.
///    Enumeration values for each byte are as follows:
///    - None = 0 = portCC2State_None
///    - Invalid = 1 = portCC2State_Invalid
///    - Rp (default) = 2 = portCC2State_RpDefault
///    - Rp (1.5A) = 3 = portCC2State_Rp1p5
///    - Rp (3A) = 4 = portCC2State_Rp3p0
///    - Rd = 5 = portCC2State_Rd
///    - Ra = 6 = portCC2State_Ra
///    - Managed by controller = 7 = portCC2State_Managed
///    - Unknown = 8 = portCC2State_Unknown
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall port_getCC2State ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif