/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_PowerDeliveryEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_POWERDELIVERYENTITY_CCA_H__
#define __AUTOGEN_POWERDELIVERYENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup PowerDeliveryEntity PowerDelivery Entity
/// PowerDeliveryClass:
/// Power Delivery or PD is a power specification which allows more charging options
/// and device behaviors within the USB interface.  This Entity will allow you to directly
/// access the vast landscape of PD.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Gets the current state of the connection in the form of an enumeration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Pointer to be filled with the current connection state.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getConnectionState ( unsigned int* id, struct Result* result, const int index );

/// Gets the number of Power Data Objects (PDOs) for a given partner and power role.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the number of PDOs.
/// \param index The index of the entity in question.
/// \param partner Indicates which side of the PD connection is in question.
///     - Local = 0 = powerdeliveryPartnerLocal
///     - Remote = 1 = powerdeliveryPartnerRemote
/// \param powerRole Indicates which power role of PD connection is in question.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getNumberOfPowerDataObjects ( unsigned int* id, struct Result* result, const int index, const unsigned char partner, const unsigned char powerRole );

/// Gets the Power Data Object (PDO) for the requested partner, powerRole and index.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the requested power rule.
/// \param index The index of the entity in question.
/// \param partner Indicates which side of the PD connection is in question.
///     - Local = 0 = powerdeliveryPartnerLocal
///     - Remote = 1 = powerdeliveryPartnerRemote
/// \param powerRole Indicates which power role of PD connection is in question.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getPowerDataObject ( unsigned int* id, struct Result* result, const int index, const unsigned char partner,  const unsigned char powerRole, const unsigned char ruleIndex );

/// Sets the Power Data Object (PDO) of the local partner for a given power role and index.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// \param pdo Power Data Object to be set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setPowerDataObject ( unsigned int* id, struct Result* result, const int index, const unsigned char powerRole,  const unsigned char ruleIndex, const unsigned int pdo );

/// Resets the Power Data Object (PDO) of the Local partner for a given power role and index.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_resetPowerDataObjectToDefault ( unsigned int* id, struct Result* result, const int index, const unsigned char powerRole, const unsigned char ruleIndex );

/// Gets all Power Data Objects (PDOs).
/// Equivalent to calling PowerDeliveryClass::getPowerDataObject() on all partners, power roles, and index's.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
///    On success this value should be 28 (7 rules * 2 partners * 2 power roles)
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// The order of which is:
///     - Rules 1-7 Local Source
///     - Rules 1-7 Local Sink
///     - Rules 1-7 Partner Source
///     - Rules 1-7 Partner Sink.
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getPowerDataObjectList ( unsigned int* id, struct Result* result, const int index, unsigned int * buffer, const unsigned int bufferLength );

/// Gets the enabled state of the Local Power Data Object (PDO) for a given power role and index.
/// Enabled refers to whether the PDO will be advertised when a PD connection is made.
/// This does not indicate the currently active rule index. This information can be found in Request Data Object (RDO).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with enabled state.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getPowerDataObjectEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char powerRole, const unsigned char ruleIndex );

/// Sets the enabled state of the Local Power Data Object (PDO) for a given powerRole and index.
/// Enabled refers to whether the PDO will be advertised when a PD connection is made.
/// This does not indicate the currently active rule index. This information can be found in Request Data Object (RDO).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// \param enabled The state to be set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setPowerDataObjectEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char powerRole,  const unsigned char ruleIndex, const unsigned char enabled );

/// Gets all Power Data Object enables for a given power role.
/// Equivalent of calling PowerDeliveryClass::getPowerDataObjectEnabled() for all indexes.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with a mapped representation of the enabled PDOs for a
///    given power role. Values align with a given rule index (bits 1-7, bit 0 is invalid)
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getPowerDataObjectEnabledList ( unsigned int* id, struct Result* result, const int index, const unsigned char powerRole );

/// Gets the current Request Data Object (RDO) for a given partner.
/// RDOs:   Are provided by the sinking device.
///       Exist only after a successful PD negotiation (Otherwise zero).
///       Only one RDO can exist at a time. i.e. Either the Local or Remote partner RDO
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the current RDO. Zero indicates the RDO is not active.
/// \param index The index of the entity in question.
/// \param partner Indicates which side of the PD connection is in question.
///     - Local = 0 = powerdeliveryPartnerLocal
///     - Remote = 1 = powerdeliveryPartnerRemote
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getRequestDataObject ( unsigned int* id, struct Result* result, const int index, const unsigned char partner );

/// Sets the current Request Data Object (RDO) for a given partner.
/// (Only the local partner can be changed.)
/// RDOs:   Are provided by the sinking device.
///       Exist only after a successful PD negotiation (Otherwise zero).
///       Only one RDO can exist at a time. i.e. Either the Local or Remote partner RDO
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param rdo Request Data Object to be set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setRequestDataObject ( unsigned int* id, struct Result* result, const int index, const unsigned int rdo );

/// Gets the power role that is currently being advertised by the local partner. (CC Strapping).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filed with the power role
///    - Disabled = 0 = powerdeliveryPowerRoleDisabled
///    - Source = 1= powerdeliveryPowerRoleSource
///    - Sink = 2 = powerdeliveryPowerRoleSink
///    - Source/Sink = 3 = powerdeliveryPowerRoleSourceSink (Dual Role Port)
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getPowerRole ( unsigned int* id, struct Result* result, const int index );

/// Set the current power role to be advertised by the Local partner. (CC Strapping).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param powerRole Value to be applied.
///     - Disabled = 0 = powerdeliveryPowerRoleDisabled
///     - Source = 1= powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
///     - Source/Sink = 3 = powerdeliveryPowerRoleSourceSink (Dual Role Port)
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setPowerRole ( unsigned int* id, struct Result* result, const int index, const unsigned char powerRole );

/// Gets the preferred power role currently being advertised by the Local partner. (CC Strapping).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Value to be applied.
///    - Disabled = 0 = powerdeliveryPowerRoleDisabled
///    - Source = 1= powerdeliveryPowerRoleSource
///    - Sink = 2 = powerdeliveryPowerRoleSink
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getPowerRolePreferred ( unsigned int* id, struct Result* result, const int index );

/// Set the preferred power role to be advertised by the Local partner (CC Strapping).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param powerRole Value to be applied.
///     - Disabled = 0 = powerdeliveryPowerRoleDisabled
///     - Source = 1= powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setPowerRolePreferred ( unsigned int* id, struct Result* result, const int index, const unsigned char powerRole );

/// Gets the maximum voltage capability reported by the e-mark of the attached cable.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of voltage.
///    - Unknown/Unattached (0)
///    - 20 Volts DC (1)
///    - 30 Volts DC (2)
///    - 40 Volts DC (3)
///    - 50 Volts DC (4)
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getCableVoltageMax ( unsigned int* id, struct Result* result, const int index );

/// Gets the maximum current capability report by the e-mark of the attached cable.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of current.
///    - Unknown/Unattached (0)
///    - 3 Amps (1)
///    - 5 Amps (2)
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getCableCurrentMax ( unsigned int* id, struct Result* result, const int index );

/// Gets the maximum data rate capability reported by the e-mark of the attached cable.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of data speed.
///    - Unknown/Unattached (0)
///    - USB 2.0 (1)
///    - USB 3.2 gen 1 (2)
///    - USB 3.2 / USB 4 gen 2 (3)
///    - USB 4 gen 3 (4)
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getCableSpeedMax ( unsigned int* id, struct Result* result, const int index );

/// Gets the cable type reported by the e-mark of the attached cable.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of the cable type.
///    - Invalid, no e-mark and not Vconn powered (0)
///    - Passive cable with e-mark (1)
///    - Active cable (2)
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getCableType ( unsigned int* id, struct Result* result, const int index );

/// Gets the current orientation being used for PD communication
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable filled with an enumeration of the orientation.
///    - Unconnected (0)
///    - CC1 (1)
///    - CC2 (2)
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getCableOrientation ( unsigned int* id, struct Result* result, const int index );

/// Requests an action of the Remote partner.
/// Actions are not guaranteed to occur.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param request Request to be issued to the remote partner
///     - pdRequestHardReset (0)
///     - pdRequestSoftReset (1)
///     - pdRequestDataReset (2)
///     - pdRequestPowerRoleSwap (3)
///     - pdRequestPowerFastRoleSwap (4)
///     - pdRequestDataRoleSwap (5)
///     - pdRequestVconnSwap (6)
///     - pdRequestSinkGoToMinimum (7)
///     - pdRequestRemoteSourcePowerDataObjects (8)
///     - pdRequestRemoteSinkPowerDataObjects (9)
/// \details The returned error represents the success of the request being sent to the partner only.
/// The success of the request being serviced by the remote partner can be obtained
/// through PowerDeliveryClass::requestStatus()
/// Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_request ( unsigned int* id, struct Result* result, const int index, const unsigned char request );

/// Gets the status of the last request command sent.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the status
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_requestStatus ( unsigned int* id, struct Result* result, const int index );

/// Gets the current enabled overrides
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Bit mapped representation of the current override configuration.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getOverride ( unsigned int* id, struct Result* result, const int index );

/// Sets the current enabled overrides
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param overrides Overrides to be set in a bit mapped representation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setOverride ( unsigned int* id, struct Result* result, const int index, const unsigned int overrides );

/// Resets the PowerDeliveryClass Entity to it factory default configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
aLIBEXPORT void __stdcall powerdelivery_resetEntityToFactoryDefaults ( unsigned int* id, struct Result* result, const int index );

/// Gets the current mode of the local partner flag/advertisement.
/// These flags are apart of the first Local Power Data Object and must be managed in order to
/// accurately represent the system to other PD devices. This API allows overriding of that feature.
/// Overriding may lead to unexpected behaviors.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the current mode.
///    - Disabled (0)
///    - Enabled (1)
///    - Auto (2) default
/// \param index The index of the entity in question.
/// \param flag Flag/Advertisement to be modified
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getFlagMode ( unsigned int* id, struct Result* result, const int index, const unsigned char flag );

/// Sets how the local partner flag/advertisement is managed.
/// These flags are apart of the first Local Power Data Object and must be managed in order to
/// accurately represent the system  to other PD devices. This API allows overriding of that feature.
/// Overriding may lead to unexpected behaviors.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param flag Flag/Advertisement to be modified
/// \param mode Value to be applied.
///     - Disabled (0)
///     - Enabled (1)
///     - Auto (2) default
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setFlagMode ( unsigned int* id, struct Result* result, const int index, const unsigned char flag, const unsigned char mode );

/// Gets the Peak Current Configuration for the Local Source.
/// The peak current configuration refers to the allowable tolerance/overload capabilities
/// in regards to the devices max current.  This tolerance includes a maximum value and a time unit.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    An enumerated value referring to the current configuration.
///    - Allowable values are 0 - 4
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getPeakCurrentConfiguration ( unsigned int* id, struct Result* result, const int index );

/// Sets the Peak Current Configuration for the Local Source.
/// The peak current configuration refers to the allowable tolerance/overload capabilities
/// in regards to the devices max current.  This tolerance includes a maximum value and a time unit.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param configuration An enumerated value referring to the configuration to be set
///     - Allowable values are 0 - 4
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setPeakCurrentConfiguration ( unsigned int* id, struct Result* result, const int index, const unsigned char configuration );

/// Gets the Fast Role Swap Current
/// The fast role swap current refers to the amount of current required by the Local Sink
/// in order to successfully preform the swap.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    An enumerated value referring to current swap value.
///    - 0A (0)
///    - 900mA (1)
///    - 1.5A (2)
///    - 3A (3)
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_getFastRoleSwapCurrent ( unsigned int* id, struct Result* result, const int index );

/// Sets the Fast Role Swap Current
/// The fast role swap current refers to the amount of current required by the Local Sink
/// in order to successfully preform the swap.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param swapCurrent An enumerated value referring to value to be set.
///     - 0A (0)
///     - 900mA (1)
///     - 1.5A (2)
///     - 3A (3)
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall powerdelivery_setFastRoleSwapCurrent ( unsigned int* id, struct Result* result, const int index, const unsigned char swapCurrent );

/// Helper function for packing Data Object attributes.
/// This value is used as a subindex for all Data Object calls with the BrainStem Protocol.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param attributes variable to be filled with packed values.
/// \param partner Indicates which side of the PD connection.
///     - Local = 0 = powerdeliveryPartnerLocal
///     - Remote = 1 = powerdeliveryPartnerRemote
/// \param powerRole Indicates which power role of PD connection.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex Data object index.
/// \details aErrNone on success; aErrParam with bad input.
aLIBEXPORT void __stdcall powerdelivery_packDataObjectAttributes ( unsigned int* id, struct Result* result, const int index, unsigned char * attributes,   const unsigned char partner,  const unsigned char powerRole, const unsigned char ruleIndex );

/// Helper function for unpacking Data Object attributes.
/// This value is used as a subindex for all Data Object calls with the BrainStem Protocol.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Data object index.
/// \param index The index of the entity in question.
/// \param attributes variable to be filled with packed values.
/// \param partner Indicates which side of the PD connection.
///     - Local = 0 = powerdeliveryPartnerLocal
///     - Remote = 1 = powerdeliveryPartnerRemote
/// \param powerRole Indicates which power role of PD connection.
///     - Source = 1 = powerdeliveryPowerRoleSource
///     - Sink = 2 = powerdeliveryPowerRoleSink
/// \details aErrNone on success; aErrParam with bad input.
aLIBEXPORT void __stdcall powerdelivery_unpackDataObjectAttributes ( unsigned int* id, struct Result* result, const int index, const unsigned char attributes,  unsigned char * partner, unsigned char * powerRole );


#ifdef __cplusplus
}
#endif

#endif