/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_RCServoEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_RCSERVOENTITY_CCA_H__
#define __AUTOGEN_RCSERVOENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup RCServoEntity RCServo Entity
/// RCServoClass:
/// Interface to servo entities on BrainStem modules.
/// Servo entities are built upon the digital input/output pins and therefore
/// can also be inputs or outputs. Please see the product datasheet on the
/// configuration limitations.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Enable the servo channel
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable The state to be set. 0 is disabled, 1 is enabled.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rcservo_setEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Get the enable status of the servo channel.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current enable status of the servo entity. 0 is disabled,
///    1 is enabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rcservo_getEnable ( unsigned int* id, struct Result* result, const int index );

/// Set the position of the servo channel
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param position The position to be set. Default 64 = a 1ms pulse and
/// 192 = a 2ms pulse.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rcservo_setPosition ( unsigned int* id, struct Result* result, const int index, const unsigned char position );

/// Get the position of the servo channel
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current position of the servo channel. Default
///    64 = a 1ms pulse and 192 = a 2ms pulse.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rcservo_getPosition ( unsigned int* id, struct Result* result, const int index );

/// Set the output to be reversed on the servo channel
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param reverse Reverses the value set by "setPosition".  ie. if the
/// position is set to 64 (1ms pulse) the output will now be 192 (2ms pulse);
/// however, "getPostion" will return the set value of 64. 0 = not reversed,
/// 1 = reversed.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rcservo_setReverse ( unsigned int* id, struct Result* result, const int index, const unsigned char reverse );

/// Get the reverse status of the servo channel
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current reverse status of the servo entity. 0 = not
///    reversed, 1 = reversed.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rcservo_getReverse ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif