/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_RailEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_RAILENTITY_CCA_H__
#define __AUTOGEN_RAILENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup RailEntity Rail Entity
/// RailClass:
/// Provides power rail functionality on certain modules.
/// This entity is only available on certain modules. The RailClass can
/// be used to control power to downstream devices. It has the ability to
/// take current and voltage measurements, and depending on hardware, may
/// have additional modes and capabilities.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the rail current.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current in micro-amps (1 == 1e-6A).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getCurrent ( unsigned int* id, struct Result* result, const int index );

/// Set the rail supply current. Rail current control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail current capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param microamps The current in micro-amps (1 == 1e-6A) to be supply by the rail.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setCurrentSetpoint ( unsigned int* id, struct Result* result, const int index, const int microamps );

/// Get the rail setpoint current. Rail current control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail current capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current in micro-amps (1 == 1e-6A) the rail is trying to
///    achieve. On some modules this is a measured value so it may not exactly match what was
///    previously set via the setCurrent interface. Refer to the module datasheet to
///    to determine if this is a measured or stored value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getCurrentSetpoint ( unsigned int* id, struct Result* result, const int index );

/// Set the rail current limit setting. (Check product datasheet to see if this feature is available)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param microamps The current in micro-amps (1 == 1e-6A).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setCurrentLimit ( unsigned int* id, struct Result* result, const int index, const int microamps );

/// Get the rail current limit setting. (Check product datasheet to see if this feature is available)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current in micro-amps (1 == 1e-6A).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getCurrentLimit ( unsigned int* id, struct Result* result, const int index );

/// Get the rail temperature.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The measured temperature associated with the rail in
///    micro-Celsius (1 == 1e-6˚C). The temperature may be associated with the module's
///    internal rail circuitry or an externally connected temperature sensors. Refer to
///    the module datasheet for definition of the temperature measurement location and
///    specific capabilities.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getTemperature ( unsigned int* id, struct Result* result, const int index );

/// Get the state of the external rail switch. Not all rails can be switched
/// on and off. Refer to the module datasheet for capability specification of the rails.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    true: enabled: connected to the supply rail voltage;
///    false: disabled: disconnected from the supply rail voltage
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getEnable ( unsigned int* id, struct Result* result, const int index );

/// Set the state of the external rail switch. Not all rails can be switched
/// on and off. Refer to the module datasheet for capability specification of the rails.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param bEnable true: enable and connect to the supply rail voltage;
/// false: disable and disconnect from the supply rail voltage
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char bEnable );

/// Get the rail supply voltage. Rail voltage control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail voltage capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The voltage in micro-volts (1 == 1e-6V) currently supplied by
///    the rail. On some modules this is a measured value so it may not exactly match what was
///    previously set via the setVoltage interface. Refer to the module datasheet to
///    to determine if this is a measured or stored value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getVoltage ( unsigned int* id, struct Result* result, const int index );

/// Set the rail supply voltage. Rail voltage control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail voltage capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param microvolts The voltage in micro-volts (1 == 1e-6V) to be supplied by the rail.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setVoltageSetpoint ( unsigned int* id, struct Result* result, const int index, const int microvolts );

/// Get the rail setpoint voltage. Rail voltage control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail voltage capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The voltage in micro-volts (1 == 1e-6V) the rail is trying to
///    achieve. On some modules this is a measured value so it may not exactly match what was
///    previously set via the setVoltage interface. Refer to the module datasheet to
///    to determine if this is a measured or stored value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getVoltageSetpoint ( unsigned int* id, struct Result* result, const int index );

/// Set the rail voltage minimum limit setting. (Check product datasheet to see if this feature is available)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param microvolts The voltage in micro-volts (1 == 1e-6V).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setVoltageMinLimit ( unsigned int* id, struct Result* result, const int index, const int microvolts );

/// Get the rail voltage minimum limit setting. (Check product datasheet to see if this feature is available)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The voltage in micro-volts (1 == 1e-6V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getVoltageMinLimit ( unsigned int* id, struct Result* result, const int index );

/// Set the rail voltage maximum limit setting. (Check product datasheet to see if this feature is available)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param microvolts The voltage in micro-volts (1 == 1e-6V).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setVoltageMaxLimit ( unsigned int* id, struct Result* result, const int index, const int microvolts );

/// Get the rail voltage maximum limit setting. (Check product datasheet to see if this feature is available)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The voltage in micro-volts (1 == 1e-6V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getVoltageMaxLimit ( unsigned int* id, struct Result* result, const int index );

/// Get the rail supply power. Rail power control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail power capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The power in milli-watts (1 == 1e-3W) currently supplied by
///    the rail. On some modules this is a measured value so it may not exactly match what was
///    previously set via the setPower interface. Refer to the module datasheet to
///    to determine if this is a measured or stored value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getPower ( unsigned int* id, struct Result* result, const int index );

/// Set the rail supply power. Rail power control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail power capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param milliwatts The power in milli-watts (1 == 1e-3W) to be supplied by the rail.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setPowerSetpoint ( unsigned int* id, struct Result* result, const int index, const int milliwatts );

/// Get the rail setpoint power. Rail power control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail power capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The power in milli-watts (1 == 1e-3W) the rail is trying to
///    achieve. On some modules this is a measured value so it may not exactly match what was
///    previously set via the setPower interface. Refer to the module datasheet to
///    to determine if this is a measured or stored value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getPowerSetpoint ( unsigned int* id, struct Result* result, const int index );

/// Set the rail power maximum limit setting. (Check product datasheet to see if this feature is available)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param milliwatts The power in milli-watts (mW).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setPowerLimit ( unsigned int* id, struct Result* result, const int index, const int milliwatts );

/// Get the rail power maximum limit setting. (Check product datasheet to see if this feature is available)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The power in milli-watts (mW).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getPowerLimit ( unsigned int* id, struct Result* result, const int index );

/// Get the rail load resistance. Rail resistance control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail resistance capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The resistance in milli-ohms (1 == 1e-3Ohms) currently drawn by
///    the rail. On some modules this is a measured value so it may not exactly match what was
///    previously set via the setResistance interface. Refer to the module datasheet to
///    to determine if this is a measured or stored value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getResistance ( unsigned int* id, struct Result* result, const int index );

/// Set the rail load resistance. Rail resistance control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail resistance capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param milliohms The resistance in milli-ohms (1 == 1e-3Ohms) to be drawn by the rail.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setResistanceSetpoint ( unsigned int* id, struct Result* result, const int index, const int milliohms );

/// Get the rail setpoint resistance. Rail resistance control capabilities vary between modules.
/// Refer to the module datasheet for definition of the rail resistance capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The resistance in milli-ohms (1 == 1e-3Ohms) the rail is trying to
///    achieve. On some modules this is a measured value so it may not exactly match what was
///    previously set via the setResistance interface. Refer to the module datasheet to
///    to determine if this is a measured or stored value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getResistanceSetpoint ( unsigned int* id, struct Result* result, const int index );

/// Enable or Disable kelvin sensing on the module.
/// Refer to the module datasheet for definition of the rail kelvin sensing capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param bEnable enable or disable kelvin sensing.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setKelvinSensingEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char bEnable );

/// Determine whether kelvin sensing is enabled or disabled.
/// Refer to the module datasheet for definition of the rail kelvin sensing capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Kelvin sensing is enabled or disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getKelvinSensingEnable ( unsigned int* id, struct Result* result, const int index );

/// Determine whether kelvin sensing has been disabled by the system.
/// Refer to the module datasheet for definition of the rail kelvin sensing capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Kelvin sensing is enabled or disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getKelvinSensingState ( unsigned int* id, struct Result* result, const int index );

/// Set the operational mode of the rail.
/// Refer to the module datasheet for definition of the rail operational capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param mode The operational mode to employ.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_setOperationalMode ( unsigned int* id, struct Result* result, const int index, const unsigned char mode );

/// Determine the current operational mode of the system.
/// Refer to the module datasheet for definition of the rail operational mode capabilities.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current operational mode setting.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getOperationalMode ( unsigned int* id, struct Result* result, const int index );

/// Determine the current operational state of the system.
/// Refer to the module datasheet for definition of the rail operational states.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current operational state, hardware configuration, faults, and operating mode.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_getOperationalState ( unsigned int* id, struct Result* result, const int index );

/// Clears the current fault state of the rail.
/// Refer to the module datasheet for definition of the rail faults.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall rail_clearFaults ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif