/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_TemperatureEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_TEMPERATUREENTITY_CCA_H__
#define __AUTOGEN_TEMPERATUREENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup TemperatureEntity Temperature Entity
/// TemperatureClass:
/// This entity is only available on certain modules, and provides a
/// temperature reading in microcelsius.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the modules temperature in micro-C
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The temperature in micro-Celsius (1 == 1e-6C).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall temperature_getValue ( unsigned int* id, struct Result* result, const int index );

/// Get the module's minimum temperature in micro-C since the last power cycle.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The module's minimum temperature in micro-C
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall temperature_getValueMin ( unsigned int* id, struct Result* result, const int index );

/// Get the module's maximum temperature in micro-C since the last power cycle.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The module's maximum temperature in micro-C
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall temperature_getValueMax ( unsigned int* id, struct Result* result, const int index );

/// Resets the TemperatureClass Entity to it factory default configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
aLIBEXPORT void __stdcall temperature_resetEntityToFactoryDefaults ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif