/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_UARTEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_UARTENTITY_CCA_H__
#define __AUTOGEN_UARTENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup UARTEntity UART Entity
/// UART Class:
/// A UART is a "Universal Asynchronous Receiver/Transmitter.  Many times
/// referred to as a COM (communication), Serial, or TTY (teletypewriter) port.
///
/// The UART Class allows the enabling and disabling of the UART data lines.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Enable the UART channel.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param bEnabled true: enabled, false: disabled.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall uart_setEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char bEnabled );

/// Get the enabled state of the uart.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    true: enabled, false: disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall uart_getEnable ( unsigned int* id, struct Result* result, const int index );

/// Set the UART baud rate.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param rate baud rate.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall uart_setBaudRate ( unsigned int* id, struct Result* result, const int index, const unsigned int rate );

/// Get the UART baud rate.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Pointer variable to be filled with baud rate.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall uart_getBaudRate ( unsigned int* id, struct Result* result, const int index );

/// Set the UART protocol.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param protocol An enumeration of serial protocols.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall uart_setProtocol ( unsigned int* id, struct Result* result, const int index, const unsigned char protocol );

/// Get the UART protocol.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Pointer to where result is placed.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall uart_getProtocol ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif