# Copyright (c) 2023 Acroname Inc. - All Rights Reserved
#
# This file is part of the BrainStem development package.
# See file LICENSE or go to https://acroname.com/software/brainstem-development-kit for full license details.
import brainstem
from brainstem.result import Result

devices = brainstem.discover.getDownstreamDevices()

if devices.error == Result.NO_ERROR and len(devices.value):
    print("The following downstream devices were found:")
    print(devices.value)
else:
    print("No downstream devices were found")