/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_AppEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_APPENTITY_CCA_H__
#define __AUTOGEN_APPENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup AppEntity App Entity
/// AppClass:
/// Used to send a cmdAPP packet to the BrainStem network.
/// These commands are used for either host-to-stem or stem-to-stem interactions.
/// BrainStem modules can implement a reflex origin to complete an action when
/// a cmdAPP packet is addressed to the module.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Execute the app reflex on the module. Don't wait for a return
/// value from the execute call; this call returns immediately upon execution
/// of the module's reflex.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param appParam The app parameter handed to the reflex.
/// \details aErrNone success.
/// \details aErrTimeout The request timed out waiting to start execution.
/// \details aErrConnection No active link connection.
/// \details aErrNotFound the app reflex was not found or not enabled on
///                        the module.
aLIBEXPORT void __stdcall app_execute ( unsigned int* id, struct Result* result, const int index, const unsigned int appParam );

/// Execute the app reflex on the module. Wait for a return from the
/// reflex execution for msTimoue milliseconds. This method will block for
/// up to msTimeout.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
///    The return value filled in from the result of
///    executing the reflex routine.
/// \param index The index of the entity in question.
/// \param appParam The app parameter handed to the reflex.
/// \param msTimeout The amount of time to wait for the return value
///                  from the reflex routine. The default value is 1000
///                  milliseconds if not specified.
/// \details aErrNone success.
/// \details aErrTimeout The request timed out waiting for a response.
/// \details aErrConnection No active link connection.
/// \details aErrNotFound the app reflex was not found or not enabled on
///                        the module.
aLIBEXPORT void __stdcall app_executeAndReturn ( unsigned int* id, struct Result* result, const int index, const unsigned int appParam , const unsigned int msTimeout );


#ifdef __cplusplus
}
#endif

#endif