/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_ClockEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_CLOCKENTITY_CCA_H__
#define __AUTOGEN_CLOCKENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup ClockEntity Clock Entity
/// ClockClass:
/// Provides an interface to a real-time clock entity on a BrainStem module.
/// The clock entity may be used to get and set the real time of the system.
/// The clock entity has a one second resolution.
/// @note Clock time must be reset if power to the BrainStem module is lost.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the four digit year value (0-4095).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Get the year portion of the real-time clock value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_getYear ( unsigned int* id, struct Result* result, const int index );

/// Set the four digit year value (0-4095).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param year Set the year portion of the real-time clock value.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_setYear ( unsigned int* id, struct Result* result, const int index, const unsigned short year );

/// Get the two digit month value (1-12).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The two digit month portion of the real-time clock value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_getMonth ( unsigned int* id, struct Result* result, const int index );

/// Set the two digit month value (1-12).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param month The two digit month portion of the real-time clock value.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_setMonth ( unsigned int* id, struct Result* result, const int index, const unsigned char month );

/// Get the two digit day of month value (1-28, 29, 30 or 31 depending
/// on the month).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The two digit day portion of the real-time clock value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_getDay ( unsigned int* id, struct Result* result, const int index );

/// Set the two digit day of month value (1-28, 29, 30 or 31 depending
/// on the month).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param day The two digit day portion of the real-time clock value.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_setDay ( unsigned int* id, struct Result* result, const int index, const unsigned char day );

/// Get the two digit hour value (0-23).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The two digit hour portion of the real-time clock value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_getHour ( unsigned int* id, struct Result* result, const int index );

/// Set the two digit hour value (0-23).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param hour The two digit hour portion of the real-time clock value.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_setHour ( unsigned int* id, struct Result* result, const int index, const unsigned char hour );

/// Get the two digit minute value (0-59).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The two digit minute portion of the real-time clock value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_getMinute ( unsigned int* id, struct Result* result, const int index );

/// Set the two digit minute value (0-59).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param min The two digit minute portion of the real-time clock value.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_setMinute ( unsigned int* id, struct Result* result, const int index, const unsigned char min );

/// Get the two digit second value (0-59).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The two digit second portion of the real-time clock value.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_getSecond ( unsigned int* id, struct Result* result, const int index );

/// Set the two digit second value (0-59).
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param sec The two digit second portion of the real-time clock value.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall clock_setSecond ( unsigned int* id, struct Result* result, const int index, const unsigned char sec );


#ifdef __cplusplus
}
#endif

#endif