/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_EthernetEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_ETHERNETENTITY_CCA_H__
#define __AUTOGEN_ETHERNETENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup EthernetEntity Ethernet Entity
/// EthernetClass:
/// IP configuration.  MAC info.  BrainD port.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Sets the Ethernet's interface to enabled/disabled.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enabled 1 = enabled; 0 = disabled
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_setEnabled ( unsigned int* id, struct Result* result, const int index, const unsigned char enabled );

/// Gets the current enable value of the Ethernet interface.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    1 = Fully enabled network connectivity; 0 = Ethernet MAC is disabled.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getEnabled ( unsigned int* id, struct Result* result, const int index );

/// Get the method in which IP Address is assigned to this device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Method used.  Current methods
///    - NONE = 0
///    - STATIC = 1
///    - DHCP = 2
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getNetworkConfiguration ( unsigned int* id, struct Result* result, const int index );

/// Get the method in which IP Address is assigned to this device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param addressStyle Method to use.  See
///   getNetworkConfiguration for addressStyle enumerations.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_setNetworkConfiguration ( unsigned int* id, struct Result* result, const int index, const unsigned char addressStyle );

/// Get the expected IPv4 address of this device, when networkConfiguration == STATIC
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    occupied bytes in buffer, Should be 4 post-call.
///    \details The functional IPv4 address of The Module will differ
///    if NetworkConfiguration != STATIC.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
aLIBEXPORT void __stdcall ethernet_getStaticIPv4Address ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// Set the desired IPv4 address of this device, if NetworkConfiguration == STATIC
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
/// \param buffer alias to an array of uint8_t[4] with an IP address
/// \param bufferLength size of buffer.  Should be 4.
/// \details setStaticIPv4Address(192, 168, 10, 2) would equate with address "192.168.10.2"
aLIBEXPORT void __stdcall ethernet_setStaticIPv4Address ( unsigned int* id, struct Result* result, const int index, unsigned char const * buffer, unsigned int bufferLength );

/// Get the expected IPv4 netmask of this device, when networkConfiguration == STATIC
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    occupied bytes in buffer, Should be 4 post-call.
///    \details The functional IPv4 netmask of The Module will differ
///    if NetworkConfiguration != STATIC.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
aLIBEXPORT void __stdcall ethernet_getStaticIPv4Netmask ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// Set the desired IPv4 address of this device, if NetworkConfiguration == STATIC
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
/// \param buffer alias to an array of uint8_t[4] with an IP address
/// \param bufferLength size of buffer.  Should be 4.
/// \details setStaticIPv4Netmask([255, 255, 192, 0], 4) would equate
/// with address "255.255.192.0", or /18 in CIDR notation.
aLIBEXPORT void __stdcall ethernet_setStaticIPv4Netmask ( unsigned int* id, struct Result* result, const int index, unsigned char const * buffer, unsigned int bufferLength );

/// Set the desired IPv4 gateway of this device, if NetworkConfiguration == STATIC
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    occupied bytes in buffer, Should be 4 post-call.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getStaticIPv4Gateway ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// Set the desired IPv4 gateway of this device, if NetworkConfiguration == STATIC
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
/// \param buffer alias to an array of uint8_t[4] with an IP address
/// \param bufferLength size of buffer.  Should be 4.
/// \details setStaticIPv4Gateway([192, 168, 1, 1], 4) would equate
/// with address "192.168.1.1"
aLIBEXPORT void __stdcall ethernet_setStaticIPv4Gateway ( unsigned int* id, struct Result* result, const int index, unsigned char const * buffer, unsigned int bufferLength );

/// \brief Get the effective IP address of this device.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    occupied bytes in buffer, Should be 4 post-call.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getIPv4Address ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// \brief Get the effective IP netmask of this device.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    occupied bytes in buffer, Should be 4 post-call.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getIPv4Netmask ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// \brief Get the effective IP gateway of this device.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    occupied bytes in buffer, Should be 4 post-call.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getIPv4Gateway ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// \brief Set IPv4 DNS Addresses (plural), if NetworkConfiguration == STATIC
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N][4]
/// \param bufferLength Total array length in bytes.  Must be a multiple of 4.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_setStaticIPv4DNSAddress ( unsigned int* id, struct Result* result, const int index, const unsigned char * buffer, unsigned int bufferLength );

/// \brief Get IPv4 DNS addresses (plural), when NetworkConfiguration == STATIC
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length of occupied bytes of buffer, after the call.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N][4]
/// \param bufferLength Maximum length of array, in bytes.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getStaticIPv4DNSAddress ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// \brief Get effective IPv4 DNS addresses, for the current NetworkConfiguration
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length of occupied bytes of buffer, after the call.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N][4]
/// \param bufferLength Maximum length of array, in bytes.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getIPv4DNSAddress ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// \brief Set hostname that's requested when this device sends a DHCP request.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N]
/// \param bufferLength N, for N bytes.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_setHostname ( unsigned int* id, struct Result* result, const int index, const unsigned char * buffer, unsigned int bufferLength );

/// \brief Get hostname that's requested when this device sends a DHCP request.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length of occupied bytes of buffer, after the call.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N]
/// \param bufferLength N, for N bytes.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getHostname ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// \brief Get hostname that's requested when this device sends a DHCP request.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length of occupied bytes of buffer, after the call.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[6]
/// \param bufferLength length of buffer that's writeable, should be > 6.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall ethernet_getMACAddress ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, unsigned int bufferLength );

/// \brief Set the port of the BrainD HTTP server.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param port The port to be used for the BrainD server.
aLIBEXPORT void __stdcall ethernet_setBraindPort ( unsigned int* id, struct Result* result, const int index, const unsigned short port );

/// \brief Get the port (desired) of the BrainD HTTP server.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The port of the BrainD server.
/// \param index The index of the entity in question.
aLIBEXPORT void __stdcall ethernet_getBraindPort ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif