/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_HDBaseTEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_HDBASETENTITY_CCA_H__
#define __AUTOGEN_HDBASETENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup HDBaseTEntity HDBaseT Entity
/////////////////////////////////////////////////////////////
/// Congratulations! You found an Easter egg!
/// Unfortunately, this code is still under construction and should not be used.
/////////////////////////////////////////////////////////////
/// HDBaseTClass:
/// This entity is only available on certain modules, and provides a
/// Power Over Ethernet control ability.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Gets the serial number of the HDBaseT device (6 bytes)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getSerialNumber ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, const unsigned int bufferLength );

/// Gets the firmware version of the HDBaseT device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    A bit packet representation of the firmware version
///    Major: Bits 24-31; Minor: Bits 16-23; Patch: Bits 8-15; Build: Bits 0-7
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getFirmwareVersion ( unsigned int* id, struct Result* result, const int index );

/// Gets the current state of the HDBaseT link
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Bit packeted representation of the state.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getState ( unsigned int* id, struct Result* result, const int index );

/// Gets the perceived cable length
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Cable length in meters
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getCableLength ( unsigned int* id, struct Result* result, const int index );

/// Gets the Mean Squared Error (MSE)
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    A bit packed representation for A and B channels
///    Channel A: Bits 0-15; Channel B: Bits 16-31;
///    Each channel has a unit of milli-dB, represented as a signed int16_t.
///    Effective range of [-32.768dB, 32.767dB]
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getMSE ( unsigned int* id, struct Result* result, const int index );

/// Gets the number of retransmissions that have occurred
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    retransmissions since link creation.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getRetransmissionRate ( unsigned int* id, struct Result* result, const int index );

/// Gets the current link utilization
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Utilization in milli-percent
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getLinkUtilization ( unsigned int* id, struct Result* result, const int index );

/// Gets the current encoding state.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Signal modulation encoding type.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getEncodingState ( unsigned int* id, struct Result* result, const int index );

/// Gets the USB2 tree at the HDBaseT device.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getUSB2DeviceTree ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, const unsigned int bufferLength );

/// Gets the USB3 tree at the HDBaseT device.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall hdbaset_getUSB3DeviceTree ( unsigned int* id, struct Result* result, const int index, unsigned char * buffer, const unsigned int bufferLength );


#ifdef __cplusplus
}
#endif

#endif