/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_POEEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_POEENTITY_CCA_H__
#define __AUTOGEN_POEENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup POEEntity POE Entity
/////////////////////////////////////////////////////////////
/// Congratulations! You found an Easter egg!
/// Unfortunately, this code is still under construction and should not be used.
/////////////////////////////////////////////////////////////
/// POEClass:
/// This entity is only available on certain modules, and provides a
/// Power Over Ethernet control ability.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Gets the power mode of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The power mode (PD, PSE, Auto, Off).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPowerMode ( unsigned int* id, struct Result* result, const int index );

/// Sets the power mode of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param value The power mode (PD, PSE, Auto, Off).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_setPowerMode ( unsigned int* id, struct Result* result, const int index, const unsigned char value );

/// Gets the power state of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The power state (PD, PSE, Off).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPowerState ( unsigned int* id, struct Result* result, const int index );

/// Gets the sourcing class on Pair 1/2 of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The POE class being offered by the device (PSE).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair12SourcingClass ( unsigned int* id, struct Result* result, const int index );

/// Sets the sourcing class on Pair 1/2 of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param value The POE class being offered by the device (PSE).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_setPair12SourcingClass ( unsigned int* id, struct Result* result, const int index, const unsigned char value );

/// Gets the sourcing class on Pair 3/4 of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The POE class being offered by the device (PSE).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair34SourcingClass ( unsigned int* id, struct Result* result, const int index );

/// Sets the sourcing class on Pair 3/4 of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param value The POE class being offered by the device (PSE).
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_setPair34SourcingClass ( unsigned int* id, struct Result* result, const int index, const unsigned char value );

/// Gets the requested class on Pair 1/2 of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The requested POE class by the device (PD).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair12RequestedClass ( unsigned int* id, struct Result* result, const int index );

/// Gets the requested class on Pair 3/4 of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The requested POE class by the device (PD).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair34RequestedClass ( unsigned int* id, struct Result* result, const int index );

/// Gets the discovered class on Pair 1/2 of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The negotiated POE class by the device (PSE/PD).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair12DiscoveredClass ( unsigned int* id, struct Result* result, const int index );

/// Gets the discovered class on Pair 3/4 of the device
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The negotiated POE class by the device (PSE/PD).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair34DiscoveredClass ( unsigned int* id, struct Result* result, const int index );

/// Gets detected status of the POE connection on Pair 1/2
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current detected status of the pairs.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair12DetectionStatus ( unsigned int* id, struct Result* result, const int index );

/// Gets detected status of the POE connection on Pair 3/4 
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current detected status of the pairs.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair34DetectionStatus ( unsigned int* id, struct Result* result, const int index );

/// Gets the Voltage on Pair 1/2
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The voltage in microvolts (1 == 1e-6V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair12Voltage ( unsigned int* id, struct Result* result, const int index );

/// Gets the Voltage on Pair 3/4
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The voltage in microvolts (1 == 1e-6V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair34Voltage ( unsigned int* id, struct Result* result, const int index );

/// Gets the Voltage on Pair 1/2
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current in microamps (1 == 1e-6V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair12Current ( unsigned int* id, struct Result* result, const int index );

/// Gets the Voltage on Pair 3/4
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current in microamps (1 == 1e-6V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair34Current ( unsigned int* id, struct Result* result, const int index );

/// Gets the Voltage on Pair 1/2
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The resistance in milliohms (1 == 1e-3V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair12Resistance ( unsigned int* id, struct Result* result, const int index );

/// Gets the Voltage on Pair 3/4
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The resistance in milliohms (1 == 1e-3V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair34Resistance ( unsigned int* id, struct Result* result, const int index );

/// Gets the Voltage on Pair 1/2
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The capacitance in nanocoulombs (1 == 1e-9V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair12Capacitance ( unsigned int* id, struct Result* result, const int index );

/// Gets the Voltage on Pair 3/4
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The capacitance in nanocoulombs (1 == 1e-9V).
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall poe_getPair34Capacitance ( unsigned int* id, struct Result* result, const int index );

/// Resets the POEClass Entity to it factory default configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
aLIBEXPORT void __stdcall poe_resetEntityToFactoryDefaults ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif