/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_RelayEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_RELAYENTITY_CCA_H__
#define __AUTOGEN_RELAYENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup RelayEntity Relay Entity
/// RelayClass:
/// Interface to relay entities on BrainStem modules.
/// Relay entities can be set, and the voltage read.  Other capabilities
/// may be available, please see the product datasheet.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Set the enable/disable state.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param bEnable False or 0 = Disabled, True or 1 = Enabled
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall relay_setEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char bEnable );

/// Get the state.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    False or 0 = Disabled, True or 1 = Enabled
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall relay_getEnable ( unsigned int* id, struct Result* result, const int index );

/// Get the scaled micro volt value with reference to ground.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    32 bit signed integer (in micro Volts) based on the boards
///    ground and reference voltages.
///    \note Not all modules provide 32 bits of accuracy; Refer to the module's
///    datasheet to determine the analog bit depth and reference voltage.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall relay_getVoltage ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif