/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_SignalEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_SIGNALENTITY_CCA_H__
#define __AUTOGEN_SIGNALENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup SignalEntity Signal Entity
/// SignalClass:
/// Interface to digital pins configured to produce square wave signals.
/// This class is designed to allow for square waves at various frequencies and duty cycles. Control
/// is defined by specifying the wave period as (T3Time) and the active portion of the cycle as (T2Time).
/// See the entity overview section of the reference for more detail regarding the timing.
///

#ifdef __cplusplus
extern "C" {
#endif

///  Enable/Disable the signal output.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enable True to enable, false to disable
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall signal_setEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char enable );

/// Get the Enable/Disable of the signal.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    True to enable, false to disable
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall signal_getEnable ( unsigned int* id, struct Result* result, const int index );

/// Invert the signal output.
///
/// Normal mode is High on t0 then low at t2.
/// Inverted mode is Low at t0 on period start and high at t2.
///
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param invert to invert, false for normal mode.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall signal_setInvert ( unsigned int* id, struct Result* result, const int index, const unsigned char invert );

/// Get the invert status the signal output.
///
/// Normal mode is High on t0 then low at t2.
/// Inverted mode is Low at t0 on period start and high at t2.
///
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    to invert, false for normal mode.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall signal_getInvert ( unsigned int* id, struct Result* result, const int index );

/// Set the signal period or T3 in nanoseconds.
///
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param t3_nsec Integer not larger than unsigned 32 bit max value representing
///        the wave period in nanoseconds.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall signal_setT3Time ( unsigned int* id, struct Result* result, const int index, const unsigned int t3_nsec );

/// Get the signal period or T3 in nanoseconds.
///
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Integer not larger than unsigned 32 bit max value representing
///    the wave period in nanoseconds.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall signal_getT3Time ( unsigned int* id, struct Result* result, const int index );

/// Set the signal active period or T2 in nanoseconds.
///
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param t2_nsec Integer not larger than unsigned 32 bit max value representing
///        the wave active period in nanoseconds.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall signal_setT2Time ( unsigned int* id, struct Result* result, const int index, const unsigned int t2_nsec );

/// Get the signal active period or T2 in nanoseconds.
///
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Integer not larger than unsigned 32 bit max value representing
///    the wave active period in nanoseconds.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall signal_getT2Time ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif