/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_StoreEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_STOREENTITY_CCA_H__
#define __AUTOGEN_STOREENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup StoreEntity Store Entity
/// StoreClass:
/// The store provides a flat file system on modules that
/// have storage capacity. Files are referred to as slots and they have
/// simple zero-based numbers for access.
/// Store slots can be used for generalized storage and commonly contain
/// compiled reflex code (files ending in .map) or templates used by the
/// system. Slots simply contain bytes with no expected organization but
/// the code or use of the slot may impose a structure.
/// Stores have fixed indices based on type. Not every module contains a
/// store of each type. Consult the module datasheet for details on which
/// specific stores are implemented, if any, and the capacities of implemented stores.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get slot state.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    true: enabled, false: disabled.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_getSlotState ( unsigned int* id, struct Result* result, const int index, const unsigned char slot );

/// Load the slot.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// \param buffer The data.
/// \param bufferLength The data length.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_loadSlot ( unsigned int* id, struct Result* result, const int index, const unsigned char slot, unsigned char * buffer, const unsigned short bufferLength );

/// Unload the slot data.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
///    Length of data that was unloaded. Unloaded length
///    will never be larger than dataLength.
/// \param index The index of the entity in question.
/// \param buffer Byte array that the unloaded data will be placed into.
/// \param bufferLength - The length of pData buffer in bytes. This is the maximum
///                     number of bytes that should be unloaded.
/// \param slot The slot number.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_unloadSlot ( unsigned int* id, struct Result* result, const int index, const unsigned char slot, unsigned char * buffer, const unsigned int bufferLength );

/// Enable slot.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_slotEnable ( unsigned int* id, struct Result* result, const int index, const unsigned char slot );

/// Disable slot.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_slotDisable ( unsigned int* id, struct Result* result, const int index, const unsigned char slot );

/// Get the slot capacity.
/// Returns the Capacity of the slot, i.e. The number of bytes it can hold.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The slot capacity.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_getSlotCapacity ( unsigned int* id, struct Result* result, const int index, const unsigned char slot );

/// Get the slot size.
/// The slot size represents the size of the data currently filling the slot in bytes.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The slot size.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_getSlotSize ( unsigned int* id, struct Result* result, const int index, const unsigned char slot );

/// Gets the current lock state of the slot
/// Allows for write protection on a slot.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filed with the locked state.
/// \param index The index of the entity in question.
/// \param slot The slot number
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_getSlotLocked ( unsigned int* id, struct Result* result, const int index, const unsigned char slot );

/// Sets the locked state of the slot
/// Allows for write protection on a slot.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param slot The slot number
/// \param lock state to be set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall store_setSlotLocked ( unsigned int* id, struct Result* result, const int index, const unsigned char slot, const unsigned char lock );


#ifdef __cplusplus
}
#endif

#endif