/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_TimerEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_TIMERENTITY_CCA_H__
#define __AUTOGEN_TIMERENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup TimerEntity Timer Entity
/// TimerClass:
/// The Timer Class provides access to a simple scheduler.
/// The timer can set to fire only once, or to repeat at a certain
/// interval. Additionally, a timer entity can execute custom Reflex
/// routines upon firing.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the currently set expiration time in microseconds. This is not a "live" timer.
/// That is, it shows the expiration time originally set with setExpiration; it does
/// not "tick down" to show the time remaining before expiration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The timer expiration duration in microseconds.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall timer_getExpiration ( unsigned int* id, struct Result* result, const int index );

/// Set the expiration time for the timer entity. When the timer expires, it will
/// fire the associated timer[index]() reflex.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param usecDuration The duration before timer expiration in microseconds.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall timer_setExpiration ( unsigned int* id, struct Result* result, const int index, const unsigned int usecDuration );

/// Get the mode of the timer which is either single or repeat mode.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The mode of the time. aTIMER_MODE_REPEAT or aTIMER_MODE_SINGLE.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall timer_getMode ( unsigned int* id, struct Result* result, const int index );

/// Set the mode of the timer which is either single or repeat mode.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param mode The mode of the timer. aTIMER_MODE_REPEAT or aTIMER_MODE_SINGLE.
/// \details Returns \ref EntityReturnValues "common entity" return values
/// \details aErrNone Action completed successfully.
aLIBEXPORT void __stdcall timer_setMode ( unsigned int* id, struct Result* result, const int index, const unsigned char mode );


#ifdef __cplusplus
}
#endif

#endif