/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_USBSystemEntity_CCA.h                               
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_USBSYSTEMENTITY_CCA_H__
#define __AUTOGEN_USBSYSTEMENTITY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

/// \defgroup USBSystemEntity USBSystem Entity
/// USBSystem Class:
/// The USBSystem class provides high level control of the lower level Port Class.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Gets the upstream port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current upstream port.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getUpstream ( unsigned int* id, struct Result* result, const int index );

/// Sets the upstream port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param port The upstream port to set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setUpstream ( unsigned int* id, struct Result* result, const int index, const unsigned char port );

/// Gets the inter-port enumeration delay in milliseconds.
/// Delay is applied upon hub enumeration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    the current inter-port delay in milliseconds.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getEnumerationDelay ( unsigned int* id, struct Result* result, const int index );

/// Sets the inter-port enumeration delay in milliseconds.
/// Delay is applied upon hub enumeration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param msDelay The delay in milliseconds to be applied between port enables
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setEnumerationDelay ( unsigned int* id, struct Result* result, const int index, const unsigned int msDelay );

/// Gets the data role of all ports with a single call
/// Equivalent to calling PortClass::getDataRole() on each individual port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    A bit packed representation of the data role for all ports.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getDataRoleList ( unsigned int* id, struct Result* result, const int index );

/// Gets the current enabled status of all ports with a single call.
/// Equivalent to calling PortClass::setEnabled() on each port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Bit packed representation of the enabled status for all ports.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getEnabledList ( unsigned int* id, struct Result* result, const int index );

/// Sets the enabled status of all ports with a single call.
/// Equivalent to calling PortClass::setEnabled() on each port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param enabledList Bit packed representation of the enabled status for all ports to be applied.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setEnabledList ( unsigned int* id, struct Result* result, const int index, const unsigned int enabledList );

/// Gets the current mode of all ports with a single call.
/// Equivalent to calling PortClass:getMode() on each port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getModeList ( unsigned int* id, struct Result* result, const int index, unsigned int * buffer, const unsigned int bufferLength );

/// Sets the mode of all ports with a single call.
/// Equivalent to calling PortClass::setMode() on each port
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param buffer Pointer to the start of a c style buffer to be transferred.
/// \param bufferLength Length of the buffer to be transferred.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setModeList ( unsigned int* id, struct Result* result, const int index, unsigned int * buffer, const unsigned int bufferLength );

/// Gets the state for all ports with a single call.
/// Equivalent to calling PortClass::getState() on each port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getStateList ( unsigned int* id, struct Result* result, const int index, unsigned int * buffer, const unsigned int bufferLength );

/// Gets the behavior of the power manager.
/// The power manager is responsible for budgeting the power of the system.
/// i.e. What happens when requested power greater than available power.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of behavior.
///    Available behaviors are product specific. See the reference documentation.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getPowerBehavior ( unsigned int* id, struct Result* result, const int index );

/// Sets the behavior of how available power is managed.
/// i.e. What happens when requested power is greater than available power.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param behavior An enumerated representation of behavior.
/// Available behaviors are product specific. See the reference documentation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setPowerBehavior ( unsigned int* id, struct Result* result, const int index, const unsigned char behavior );

/// Gets the current power behavior configuration
/// Certain power behaviors use a list of ports to determine priority when budgeting power.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getPowerBehaviorConfig ( unsigned int* id, struct Result* result, const int index, unsigned int * buffer, const unsigned int bufferLength );

/// Sets the current power behavior configuration
/// Certain power behaviors use a list of ports to determine priority when budgeting power.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param buffer Pointer to the start of a c style buffer to be transferred.
/// \param bufferLength Length of the buffer to be transferred.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setPowerBehaviorConfig ( unsigned int* id, struct Result* result, const int index, unsigned int * buffer, const unsigned int bufferLength );

/// Gets the behavior of how upstream and downstream ports are determined.
/// i.e. How do you manage requests for data role swaps and new upstream connections.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with an enumerated representation of behavior.
///    Available behaviors are product specific. See the reference documentation.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getDataRoleBehavior ( unsigned int* id, struct Result* result, const int index );

/// Sets the behavior of how upstream and downstream ports are determined.
/// i.e. How do you manage requests for data role swaps and new upstream connections.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param behavior An enumerated representation of behavior.
/// Available behaviors are product specific. See the reference documentation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setDataRoleBehavior ( unsigned int* id, struct Result* result, const int index, const unsigned char behavior );

/// Gets the current data role behavior configuration
/// Certain data role behaviors use a list of ports to determine priority host priority.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Length that was actually received and filled.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getDataRoleBehaviorConfig ( unsigned int* id, struct Result* result, const int index, unsigned int * buffer, const unsigned int bufferLength );

/// Sets the current data role behavior configuration
/// Certain data role behaviors use a list of ports to determine host priority.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param buffer Pointer to the start of a c style buffer to be transferred.
/// \param bufferLength Length of the buffer to be transferred.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setDataRoleBehaviorConfig ( unsigned int* id, struct Result* result, const int index, unsigned int * buffer, const unsigned int bufferLength );

/// Gets the current mode of the selector input.
/// This mode determines what happens and in what order when the external
/// selector input is used.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Variable to be filled with the selector mode
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getSelectorMode ( unsigned int* id, struct Result* result, const int index );

/// Sets the current mode of the selector input.
/// This mode determines what happens and in what order when the external
/// selector input is used.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param mode Mode to be set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setSelectorMode ( unsigned int* id, struct Result* result, const int index, const unsigned char mode );

/// Resets the USBSystemClass Entity to it factory default configuration.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
aLIBEXPORT void __stdcall usbsystem_resetEntityToFactoryDefaults ( unsigned int* id, struct Result* result, const int index );

/// Gets the USB HighSpeed upstream port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current upstream port.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getUpstreamHS ( unsigned int* id, struct Result* result, const int index );

/// Sets the USB HighSpeed upstream port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param port The upstream port to set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setUpstreamHS ( unsigned int* id, struct Result* result, const int index, const unsigned char port );

/// Gets the USB SuperSpeed upstream port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    The current upstream port.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getUpstreamSS ( unsigned int* id, struct Result* result, const int index );

/// Sets the USB SuperSpeed upstream port.
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param port The upstream port to set.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setUpstreamSS ( unsigned int* id, struct Result* result, const int index, const unsigned char port );

/// Gets the current enabled overrides
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Bit mapped representation of the current override configuration.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getOverride ( unsigned int* id, struct Result* result, const int index );

/// Sets the current enabled overrides
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param overrides Overrides to be set in a bit mapped representation.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setOverride ( unsigned int* id, struct Result* result, const int index, const unsigned int overrides );

/// Sets the USB HighSpeed Max datarate
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param datarate Maximum datarate for the USB HighSpeed signals.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setDataHSMaxDatarate ( unsigned int* id, struct Result* result, const int index, const unsigned int datarate );

/// Gets the USB HighSpeed Max datarate
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Current maximum datarate for the USB HighSpeed signals.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getDataHSMaxDatarate ( unsigned int* id, struct Result* result, const int index );

/// Sets the USB SuperSpeed Max datarate
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone on success.
/// Non-zero error code on failure.
/// \param index The index of the entity in question.
/// \param datarate Maximum datarate for the USB SuperSpeed signals.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_setDataSSMaxDatarate ( unsigned int* id, struct Result* result, const int index, const unsigned int datarate );

/// Gets the USB SuperSpeed Max datarate
/// \param id ID assigned through "module_createStem"
/// \param result Object containing aErrNone and the requested value on success.
/// Non-zero error code on failure.
///    Current maximum datarate for the USB SuperSpeed signals.
/// \param index The index of the entity in question.
/// \details Returns \ref EntityReturnValues "common entity" return values
aLIBEXPORT void __stdcall usbsystem_getDataSSMaxDatarate ( unsigned int* id, struct Result* result, const int index );


#ifdef __cplusplus
}
#endif

#endif