//
//  main.cpp
//  BrainStem2Example
//
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2023 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#include <iostream>
#include "BrainStem2/BrainStem-all.h"

int main(int argc, const char * argv[]) {
    std::cout << "Creating a USBHub3c module" << std::endl;

    // Create an instance of the USBHub3p
    aUSBHub3c chub;
    aErr err = aErrNone;

    // Connect to the hardware.
    // err = chub.discoverAndConnect(USB, 0x40F5849A); // for a known serial number
    err = chub.discoverAndConnect(USB);
    if (err != aErrNone) {
        std::cout << "Error "<< err <<" encountered connecting to BrainStem module" << std::endl;
        return 1;

    }
    else { std::cout << "Connected to BrainStem module." << std::endl; }
    
    // VDM Commands are a minimum of 8 bytes chunked into 4 byte blocks
    // First 4 bytes are SOP
    //   0 = SOP
    //   1 = SOP'
    //   2 = SOP''
    //   3 = SOP' Debug
    //   4 = SOP'' Debug
    // Second 4 bytes are the VDM header according to the USB PD Standard
    // Any subsequent sets of 4 bytes are the attached VDO's
    // Example:
    // SOP           0x00000000
    // VDM Header    0xFF00A001
    // No VDOs

    // Discover Identity Command
    uint32_t buffer[] = {0x00000000, 0xFF00A001};
    
    err = chub.pd[1].setUEIBytes(powerdeliveryVDM, (uint8_t*)buffer, 8);
    printf("Sent Discover Identity VDM to Port 1, Err: %d\n", err);

    // Disconnect
    err = chub.disconnect();
    if (err == aErrNone) {
        std::cout << std::endl;
        std::cout << "Disconnected from USBHub3c." << std::endl;
    }

    return 0;
}
