﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

using Acroname.BrainStem2CLI;

namespace BrainStem2CLI_USBHub2x4
{
    class Program
    {
        static void Main(string[] args)
        {

            Console.WriteLine("Creating USBHub2x4 module");
            USBHub2x4 stem = new USBHub2x4();

            //Supplying a serial number of 0 will result in the device connecting
            //to the first USBHub2x4 the function finds.
            aErr err = stem.module.discoverAndConnect(m_linkType.USB, 0);

            if(err != aErr.aErrNone)  {
                Console.WriteLine("Error connecting to device: {0}", err);
                Console.WriteLine("Press enter to exit");
                Console.ReadLine();
                System.Environment.Exit(1);
            }
            else {
                Console.WriteLine("Successfully connected to BrainStem module");
            }

            Console.WriteLine("Disabling all ports");
            for(byte i = 0; i < 4; i++)  {
                err = stem.usb.setPortDisable(i);
                Console.WriteLine("    Port: {0}, Error: {1}", i, err);
                //Finer control can be achieved by using the functions below.
                //stem.usb.setPowerDisable(i);
                //stem.usb.setDataDisable(i);
                Thread.Sleep(500);
            }

            Console.WriteLine("Enabling all ports");
            for (byte i = 0; i < 4; i++)
            {
                err = stem.usb.setPortEnable(i);
                Console.WriteLine("    Port: {0}, Error: {1}", i, err);
                //Finer control can be achieved by using the functions below.
                //stem.usb.setPowerEnable(i);
                //stem.usb.setDataEnable(i);
                Thread.Sleep(500);
            }

            Console.WriteLine("Disconnecting from BrainStem Module");
            err = stem.module.disconnect();

            Console.WriteLine("Press enter to exit");
            Console.ReadLine();
        }
    }
}
