/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: aPD3M.h	     	  	                                   //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// description: PD3M C++ Module object.                            //
//                                                                 //
// build number: source                                            //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2018 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __aPD3M_H__
#define __aPD3M_H__

#include "BrainStem-all.h"
#include "aProtocoldefs.h"

#ifdef PRE_RELEASE
#include "BrainStem-PreRelease.h"
#endif

/**
 * \defgroup PD3M_Constants USBHub3c Module Constants
 * @{
 */
#define aPD3M_MODULE                                          18 /**< PD3M module number */

#define aPD3M_NUM_PORTS                                       1 /**< Number of Ports available */
#define aPD3M_NUM_PD_PORTS                                    1 /**< Number of PD compatible ports available */
#define aPD3M_NUM_PD_RULES_PER_PORT                           7 /**< Number of PD Rules per port available */

/** @} */

#if defined(__cplusplus)

///  \brief Concrete Module implementation of a PD3M
///         Allows a user to connect to and control an attached hub
class aPD3M : public Acroname::BrainStem::Module
{
public:

    aPD3M(const uint8_t module = aPD3M_MODULE,
              bool bAutoNetworking = true,
              const uint8_t model = aMODULE_TYPE_PD3M) :
    Acroname::BrainStem::Module(module, bAutoNetworking, model)
    {
        system.init(this, 0);
        pd.init(this, 0);
        port.init(this, 0);
    }
    
    Acroname::BrainStem::SystemClass system;
    Acroname::BrainStem::PowerDeliveryClass pd;
    Acroname::BrainStem::PortClass port;
};

#endif//defined(__cplusplus)

#endif /* __aPD3M_H__ */
