/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_EqualizerClass_CPP.h                              //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_EQUALIZER_CPP_H__
#define __AUTOGEN_EQUALIZER_CPP_H__

#include "BrainStem-core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

#if defined(__cplusplus)

namespace Acroname {
namespace BrainStem {

/// EqualizerClass:
/// Provides receiver and transmitter gain/boost/emphasis settings for some of Acroname's
///   products.
/// Please see product documentation for further details.
/// 
class aLIBEXPORT EqualizerClass : public EntityClass {

public:

    /// Constructor.
    EqualizerClass(void);

    /// Destructor.
    virtual ~EqualizerClass(void);

    /// Initialize the Equalizer Class.
    ///
    /// \param pModule The module to which this entity belongs.
    /// \param index The index of the Equalizer entity to be addressed.
    ///
    void init(Module* pModule, const uint8_t index);

    /// Sets the receiver configuration for a given channel.
    /// 
    /// \param channel The equalizer receiver channel.
    /// \param config Configuration to be applied to the receiver.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setReceiverConfig(const uint8_t channel, const uint8_t config);

    /// Gets the receiver configuration for a given channel.
    /// 
    /// \param channel The equalizer receiver channel.
    /// \param config Configuration of the receiver.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getReceiverConfig(const uint8_t channel, uint8_t* config);

    /// Sets the transmitter configuration
    /// 
    /// \param config Configuration to be applied to the transmitter.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setTransmitterConfig(const uint8_t config);

    /// Gets the transmitter configuration
    /// 
    /// \param config Configuration of the Transmitter.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getTransmitterConfig(uint8_t* config);



};

} // namespace BrainStem
} // namespace Acroname

#endif // defined(__cplusplus)

#endif // __AUTOGEN_EQUALIZER_CPP_H__