/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_TemperatureClass_CPP.h                            //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_TEMPERATURE_CPP_H__
#define __AUTOGEN_TEMPERATURE_CPP_H__

#include "BrainStem-core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

#if defined(__cplusplus)

namespace Acroname {
namespace BrainStem {

/// TemperatureClass:
/// This entity is only available on certain modules, and provides a temperature reading in
///   microcelsius.
/// 
class aLIBEXPORT TemperatureClass : public EntityClass {

public:

    /// Constructor.
    TemperatureClass(void);

    /// Destructor.
    virtual ~TemperatureClass(void);

    /// Initialize the Temperature Class.
    ///
    /// \param pModule The module to which this entity belongs.
    /// \param index The index of the Temperature entity to be addressed.
    ///
    void init(Module* pModule, const uint8_t index);

    /// Get the modules temperature in micro-C
    /// 
    /// \param temp The temperature in micro-Celsius (1 == 1e-6C).
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getValue(int32_t* temp);

    /// Get the module's minimum temperature in micro-C since the last power cycle.
    /// 
    /// \param minTemp The module's minimum temperature in micro-C
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getValueMin(int32_t* minTemp);

    /// Get the module's maximum temperature in micro-C since the last power cycle.
    /// 
    /// \param maxTemp The module's maximum temperature in micro-C
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getValueMax(int32_t* maxTemp);



};

} // namespace BrainStem
} // namespace Acroname

#endif // defined(__cplusplus)

#endif // __AUTOGEN_TEMPERATURE_CPP_H__