/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_AppClass_CCA.h                                    //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_APP_CCA_H__
#define __AUTOGEN_APP_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup AppEntity App Entity
/// Used to send a cmdAPP packet to the BrainStem network.
/// These commands are used for either host-to-stem or stem-to-stem interactions.
/// BrainStem modules can implement a reflex origin to complete an action when a cmdAPP packet
///   is addressed to the module.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Execute the app reflex on the module.
/// Doesn't wait for a return value from the execute call; this call returns immediately upon
///   execution of the module's reflex.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param appParam The app parameter handed to the reflex.
/// 
aLIBEXPORT void __stdcall app_execute(unsigned int* id, struct Result* result, const int index, const unsigned int appParam);

/// Execute the app reflex on the module.
/// Waits for a return from the reflex execution for msTimeout milliseconds.
/// This method will block for up to msTimeout.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The return value filled in from the result of executing the reflex routine.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param appParam The app parameter handed to the reflex.
/// \param msTimeout The amount of time to wait for the return value from the reflex routine.
///        The default value is 1000 milliseconds if not specified.
/// 
aLIBEXPORT void __stdcall app_executeAndReturn(unsigned int* id, struct Result* result, const int index, const unsigned int appParam, const unsigned int msTimeout);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_APP_CCA_H__