/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_DigitalClass_CCA.h                                //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_DIGITAL_CCA_H__
#define __AUTOGEN_DIGITAL_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup DigitalEntity Digital Entity
/// Interface to digital entities on BrainStem modules.
/// Digital entities have the following 5 possibilities: Digital Input, Digital Output,
///   RCServo Input, RCServo Output, and HighZ.
/// Other capabilities may be available and not all pins support all configurations. Please
///   see the product datasheet.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Set the digital configuration to one of the available 5 states.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param configuration The configuration to be applied
///            - Digital Input: digitalConfigurationInput = 0
///            - Digital Output: digitalConfigurationOutput = 1
///            - RCServo Input: digitalConfigurationRCServoInput = 2
///            - RCServo Output: digitalConfigurationRCServoOutput = 3
///            - High Z State: digitalConfigurationHiZ = 4
///            - Digital Input: digitalConfigurationInputPullUp = 0
///            - Digital Input: digitalConfigurationInputNoPull = 4
///            - Digital Input: digitalConfigurationInputPullDown = 5
/// 
/// \note Some configurations are only supported on specific pins.
/// 
aLIBEXPORT void __stdcall digital_setConfiguration(unsigned int* id, struct Result* result, const int index, const unsigned char configuration);

/// Get the digital configuration.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Current configuration of the digital entity.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall digital_getConfiguration(unsigned int* id, struct Result* result, const int index);

/// Set the logical state.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param state The state to be set. 0 is logic low, 1 is logic high.
/// 
aLIBEXPORT void __stdcall digital_setState(unsigned int* id, struct Result* result, const int index, const unsigned char state);

/// Get the state.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current state of the digital entity. 0 is logic low, 1 is logic high.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
/// \note If in high Z state an error will be returned.
/// 
aLIBEXPORT void __stdcall digital_getState(unsigned int* id, struct Result* result, const int index);

/// Sets the logical state of all available digitals based on the bit mapping.
/// Number of digitals varies across BrainStem modules.
/// Refer to the datasheet for the capabilities of your module.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param state The state to be set for all digitals in a bit mapped representation.
///        0 is logic low, 1 is logic high. Where bit 0 = digital 0, bit 1 = digital 1 etc.
/// 
aLIBEXPORT void __stdcall digital_setStateAll(unsigned int* id, struct Result* result, const int index, const unsigned int state);

/// Gets the logical state of all available digitals in a bit mapped representation.
/// Number of digitals varies across BrainStem modules.
/// Refer to the datasheet for the capabilities of your module.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The state of all digitals where bit 0 = digital 0,
///              bit 1 = digital 1 etc. 0 is logic low, 1 is logic high.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall digital_getStateAll(unsigned int* id, struct Result* result, const int index);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_DIGITAL_CCA_H__