/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_EqualizerClass_CCA.h                              //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_EQUALIZER_CCA_H__
#define __AUTOGEN_EQUALIZER_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup EqualizerEntity Equalizer Entity
/// Provides receiver and transmitter gain/boost/emphasis settings for some of Acroname's
///   products.
/// Please see product documentation for further details.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Sets the receiver configuration for a given channel.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The equalizer receiver channel.
/// \param config Configuration to be applied to the receiver.
/// 
aLIBEXPORT void __stdcall equalizer_setReceiverConfig(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned char config);

/// Gets the receiver configuration for a given channel.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Configuration of the receiver.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The equalizer receiver channel.
/// 
aLIBEXPORT void __stdcall equalizer_getReceiverConfig(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Sets the transmitter configuration
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param config Configuration to be applied to the transmitter.
/// 
aLIBEXPORT void __stdcall equalizer_setTransmitterConfig(unsigned int* id, struct Result* result, const int index, const unsigned char config);

/// Gets the transmitter configuration
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Configuration of the Transmitter.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall equalizer_getTransmitterConfig(unsigned int* id, struct Result* result, const int index);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_EQUALIZER_CCA_H__