/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_EthernetClass_CCA.h                               //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_ETHERNET_CCA_H__
#define __AUTOGEN_ETHERNET_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup EthernetEntity Ethernet Entity
/// IP configuration.  MAC info.  BrainD port.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Sets the Ethernet's interface to enabled/disabled.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param enabled 1 = enabled; 0 = disabled
/// 
aLIBEXPORT void __stdcall ethernet_setEnabled(unsigned int* id, struct Result* result, const int index, const unsigned char enabled);

/// Gets the current enable value of the Ethernet interface.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: 1 = Fully enabled network connectivity; 0 = Ethernet MAC is disabled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall ethernet_getEnabled(unsigned int* id, struct Result* result, const int index);

/// Get the method in which IP Address is assigned to this device
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Method used.  Current methods
///                \li NONE = 0
///                \li STATIC = 1
///                \li DHCP = 2
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall ethernet_getNetworkConfiguration(unsigned int* id, struct Result* result, const int index);

/// Get the method in which IP Address is assigned to this device
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param addressStyle Method to use.  See getNetworkConfiguration for addressStyle
///        enumerations.
/// 
aLIBEXPORT void __stdcall ethernet_setNetworkConfiguration(unsigned int* id, struct Result* result, const int index, const unsigned char addressStyle);

/// Get the expected IPv4 address of this device, when networkConfiguration == STATIC
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: occupied bytes in buffer, Should be 4 post-call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// 
/// \note The functional IPv4 address of The Module will differ if NetworkConfiguration !=
///       STATIC.
/// 
aLIBEXPORT void __stdcall ethernet_getStaticIPv4Address(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Set the desired IPv4 address of this device, if NetworkConfiguration == STATIC.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] with an IP address
/// \param bufferLength size of buffer.  Should be 4.
/// 
aLIBEXPORT void __stdcall ethernet_setStaticIPv4Address(unsigned int* id, struct Result* result, const int index, const unsigned char* buffer, const unsigned int bufferLength);

/// Get the expected IPv4 netmask of this device, when networkConfiguration == STATIC
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: occupied bytes in buffer, Should be 4 post-call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// 
/// \note The functional IPv4 netmask of The Module will differ if NetworkConfiguration !=
///       STATIC.
/// 
aLIBEXPORT void __stdcall ethernet_getStaticIPv4Netmask(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Set the desired IPv4 address of this device, if NetworkConfiguration == STATIC
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] with an IP address
/// \param bufferLength size of buffer.  Should be 4.
/// 
aLIBEXPORT void __stdcall ethernet_setStaticIPv4Netmask(unsigned int* id, struct Result* result, const int index, const unsigned char* buffer, const unsigned int bufferLength);

/// Get the expected IPv4 gateway of this device, when networkConfiguration == STATIC
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: occupied bytes in buffer, Should be 4 post-call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// 
aLIBEXPORT void __stdcall ethernet_getStaticIPv4Gateway(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Set the desired IPv4 gateway of this device, if NetworkConfiguration == STATIC
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] with an IP address
/// \param bufferLength size of buffer.  Should be 4.
///        setStaticIPv4Gateway([192, 168, 1, 1], 4) would equate with address "192.168.1.1"
/// 
aLIBEXPORT void __stdcall ethernet_setStaticIPv4Gateway(unsigned int* id, struct Result* result, const int index, const unsigned char* buffer, const unsigned int bufferLength);

/// Get the effective IP address of this device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: occupied bytes in buffer, Should be 4 post-call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// 
aLIBEXPORT void __stdcall ethernet_getIPv4Address(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Get the effective IP netmask of this device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: occupied bytes in buffer, Should be 4 post-call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// 
aLIBEXPORT void __stdcall ethernet_getIPv4Netmask(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Get the effective IP gateway of this device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: occupied bytes in buffer, Should be 4 post-call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[4] for returned output
/// \param bufferLength size of buffer.  Should be 4.
/// 
aLIBEXPORT void __stdcall ethernet_getIPv4Gateway(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Set IPv4 DNS Addresses (plural), if NetworkConfiguration == STATIC
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N][4]
/// \param bufferLength Total array length in bytes.  Must be a multiple of 4.
/// 
aLIBEXPORT void __stdcall ethernet_setStaticIPv4DNSAddress(unsigned int* id, struct Result* result, const int index, const unsigned char* buffer, const unsigned int bufferLength);

/// Get IPv4 DNS addresses (plural), when NetworkConfiguration == STATIC
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length of occupied bytes of buffer, after the call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N][4]
/// \param bufferLength Maximum length of array, in bytes.
/// 
aLIBEXPORT void __stdcall ethernet_getStaticIPv4DNSAddress(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Get effective IPv4 DNS addresses, for the current NetworkConfiguration
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length of occupied bytes of buffer, after the call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N][4]
/// \param bufferLength Maximum length of array, in bytes.
/// 
aLIBEXPORT void __stdcall ethernet_getIPv4DNSAddress(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Set hostname that's requested when this device sends a DHCP request.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N]
/// \param bufferLength N, for N bytes.
/// 
aLIBEXPORT void __stdcall ethernet_setHostname(unsigned int* id, struct Result* result, const int index, const unsigned char* buffer, const unsigned int bufferLength);

/// Get hostname that's requested when this device sends a DHCP request.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length of occupied bytes of buffer, after the call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[N]
/// \param bufferLength N, for N bytes.
/// 
aLIBEXPORT void __stdcall ethernet_getHostname(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Get the MAC address of the Ethernet interface.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length of occupied bytes of buffer, after the call.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer alias to an array of uint8_t[6]
/// \param bufferLength length of buffer that's writeable, should be > 6.
/// 
aLIBEXPORT void __stdcall ethernet_getMACAddress(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Set the port of a TCPIP service on the device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param service The index of the service to set the port for.
/// \param port The port to be used for the TCPIP server.
/// 
aLIBEXPORT void __stdcall ethernet_setInterfacePort(unsigned int* id, struct Result* result, const int index, const unsigned char service, const unsigned short port);

/// Get the port of a TCPIP service on the device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The port of the TCPIP server.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param service The index of the service to get the port for.
/// 
aLIBEXPORT void __stdcall ethernet_getInterfacePort(unsigned int* id, struct Result* result, const int index, const unsigned char service);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_ETHERNET_CCA_H__