/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_HDBaseTClass_CCA.h                                //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_HDBASET_CCA_H__
#define __AUTOGEN_HDBASET_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup HDBaseTEntity HDBaseT Entity
/// This entity is only available on certain modules, and provides information on HDBaseT
///   extenders.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Gets the serial number of the HDBaseT device (6 bytes)
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length that was actually received and filled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// 
aLIBEXPORT void __stdcall hdbaset_getSerialNumber(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Gets the firmware version of the HDBaseT device
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: A bit packet representation of the firmware version
///              Major: Bits 24-31; Minor: Bits 16-23; Patch: Bits 8-15; Build: Bits 0-7
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getFirmwareVersion(unsigned int* id, struct Result* result, const int index);

/// Gets the current state of the HDBaseT link
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Bit packeted representation of the state.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getState(unsigned int* id, struct Result* result, const int index);

/// Gets the perceived cable length
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Cable length in micro-meters
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getCableLength(unsigned int* id, struct Result* result, const int index);

/// Gets the Mean Squared Error (MSE) for channel A
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current MSE for channel A in micro-dB
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getMSEA(unsigned int* id, struct Result* result, const int index);

/// Gets the Mean Squared Error (MSE) for channel B
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current MSE for channel B in micro-dB
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getMSEB(unsigned int* id, struct Result* result, const int index);

/// Gets the number of successful messages between retransmission
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Instantaneous number of successful messages between retransmission.
///              To be interpreted as: 1 / retransmissionRate for rate interpretation.
///              If the value is 0, there have been no retransmissions, otherwise higher is
///              better..
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getRetransmissionRate(unsigned int* id, struct Result* result, const int index);

/// Gets the current link utilization
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Utilization in milli-percent
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getLinkUtilization(unsigned int* id, struct Result* result, const int index);

/// Gets the current encoding state.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Signal modulation encoding type.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getEncodingState(unsigned int* id, struct Result* result, const int index);

/// Gets the USB2 tree at the HDBaseT device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length that was actually received and filled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// 
aLIBEXPORT void __stdcall hdbaset_getUSB2DeviceTree(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Gets the USB3 tree at the HDBaseT device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length that was actually received and filled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// 
aLIBEXPORT void __stdcall hdbaset_getUSB3DeviceTree(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Gets the current link role
/// In the case of "Auto" the getState API will provide the current role.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Link role
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall hdbaset_getLinkRole(unsigned int* id, struct Result* result, const int index);

/// Sets the active link role
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param role The role to be set.
/// 
aLIBEXPORT void __stdcall hdbaset_setLinkRole(unsigned int* id, struct Result* result, const int index, const unsigned char role);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_HDBASET_CCA_H__