/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_I2CClass_CCA.h                                    //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_I2C_CCA_H__
#define __AUTOGEN_I2C_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup I2CEntity I2C Entity
/// Interface the I2C buses on BrainStem modules.
/// The class provides a way to send read and write commands to I2C devices on the entities
///   bus.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Read from a device on this I2C bus.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param address The I2C address (7bit <XXXX-XXX0>) of the device to read.
/// \param readLength The length of the data to read in bytes.
/// \param buffer The array of bytes that will be filled with the result, upon success.
///        This array should be larger or equivalent to aBRAINSTEM_MAXPACKETBYTES - 5
/// 
aLIBEXPORT void __stdcall i2c_read(unsigned int* id, struct Result* result, const int index, const unsigned char address, const unsigned char readLength, unsigned char* buffer);

/// Write to a device on this I2C bus.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param address The I2C address (7bit <XXXX-XXX0>) of the device to write.
/// \param bufferLength The length of the data to write in bytes.
/// \param buffer The data to send to the device
///        This array should be no larger than aBRAINSTEM_MAXPACKETBYTES - 5
/// 
aLIBEXPORT void __stdcall i2c_write(unsigned int* id, struct Result* result, const int index, const unsigned char address, const unsigned char bufferLength, const unsigned char* buffer);

/// Set bus pull-up state.
/// This call only works with stems that have software controlled pull-ups.
/// Check the datasheet for more information.
/// This parameter is saved when system.save is called.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param enable true enables pull-ups false disables them.
/// 
aLIBEXPORT void __stdcall i2c_setPullup(unsigned int* id, struct Result* result, const int index, const unsigned char enable);

/// Set I2C bus speed.
/// 
/// This call sets the communication speed for I2C transactions through this API.
/// Speed is an enumeration value which can take the following values:
///     1 - 100Khz
///     2 - 400Khz
///     3 - 1MHz
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param speed The speed setting value.
/// 
aLIBEXPORT void __stdcall i2c_setSpeed(unsigned int* id, struct Result* result, const int index, const unsigned char speed);

/// Get I2C bus speed.
/// 
/// This call gets the communication speed for I2C transactions through this API.
/// Speed is an enumeration value which can take the following values:
///     1 - 100Khz
///     2 - 400Khz
///     3 - 1MHz
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The speed setting value.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall i2c_getSpeed(unsigned int* id, struct Result* result, const int index);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_I2C_CCA_H__