/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_PoEClass_CCA.h                                    //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_POE_CCA_H__
#define __AUTOGEN_POE_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup PoEEntity PoE Entity
/// This entity is only available on certain modules, and provides a Power over Ethernet
///   control ability.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Gets the current enable value of the indicated POE pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: 1 = Enabled; 0 = Disabled;
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairEnabled(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Enables or disables the indicated POE pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// \param enable 1 = Enable port; 0 = Disable port.
/// 
aLIBEXPORT void __stdcall poe_setPairEnabled(unsigned int* id, struct Result* result, const int index, const unsigned char pair, const unsigned char enable);

/// Gets the power mode of the device
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The power mode (PD, PSE, Auto, Off).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall poe_getPowerMode(unsigned int* id, struct Result* result, const int index);

/// Sets the power mode of the device
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param value The power mode (PD, PSE, Auto, Off).
/// 
aLIBEXPORT void __stdcall poe_setPowerMode(unsigned int* id, struct Result* result, const int index, const unsigned char value);

/// Gets the power state of the device
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The power state (PD, PSE, Off).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall poe_getPowerState(unsigned int* id, struct Result* result, const int index);

/// Gets the sourcing class for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The POE class being offered by the device (PSE).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairSourcingClass(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Sets the sourcing class for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// \param value The POE class being offered by the device (PSE).
/// 
aLIBEXPORT void __stdcall poe_setPairSourcingClass(unsigned int* id, struct Result* result, const int index, const unsigned char pair, const unsigned char value);

/// Gets the requested class for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The requested POE class by the device (PD).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairRequestedClass(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Gets the discovered class for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The negotiated POE class by the device (PSE/PD).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairDiscoveredClass(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Gets detected status of the POE connection for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current detected status of the pairs.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairDetectionStatus(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Gets the Voltage for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The voltage in microvolts (1 == 1e-6V).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairVoltage(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Gets the Current for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current in microamps (1 == 1e-6V).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairCurrent(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Gets the Resistance for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The resistance in milliohms (1 == 1e-3Z).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairResistance(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Gets the Capacitance for a given pair
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The capacitance in nanofarads (1 == 1e-9F).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairCapacitance(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Get the instantaneous power consumption for a given pair
/// The equivalent of Voltage x Current
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the pairs power in milli-watts (mW).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairPower(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Gets the total instantaneous power consumption
/// The equivalent of Pair1(Voltage x Current) + Pair2(Voltage x Current)
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the total POE power in milli-watts (mW).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall poe_getTotalPower(unsigned int* id, struct Result* result, const int index);

/// Gets the accumulated power for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the total accumulated POE power in milli-watts
///              (mW).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// 
aLIBEXPORT void __stdcall poe_getPairAccumulatedPower(unsigned int* id, struct Result* result, const int index, const unsigned char pair);

/// Sets the accumulated power for a given pair.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param pair Selects PoE pair to access
///            - 0 = Pair 1/2
///            - 1 = Pair 3/4
/// \param power The power accumulator value to be set in milli-watts (mW).
/// 
aLIBEXPORT void __stdcall poe_setPairAccumulatedPower(unsigned int* id, struct Result* result, const int index, const unsigned char pair, const int power);

/// Gets the total Accumulated Power
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the total accumulated POE power in milli-watts
///              (mW).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall poe_getTotalAccumulatedPower(unsigned int* id, struct Result* result, const int index);

/// Sets the total accumulated power
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param power The power accumulator value to be set in milli-watts (mW).
/// 
aLIBEXPORT void __stdcall poe_setTotalAccumulatedPower(unsigned int* id, struct Result* result, const int index, const int power);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_POE_CCA_H__