/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_PointerClass_CCA.h                                //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_POINTER_CCA_H__
#define __AUTOGEN_POINTER_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup PointerEntity Pointer Entity
/// Allows access to the reflex scratchpad from a host computer.
/// 
/// The Pointers access the pad which is a shared memory area on a BrainStem module.
/// The interface allows the use of the BrainStem scratchpad from the host, and provides a
///   mechanism for allowing the host application and BrainStem relexes to communicate.
/// 
/// The Pointer allows access to the pad in a similar manner as a file pointer accesses the
///   underlying file.
/// The cursor position can be set via setOffset. A read of a character short or int can be
///   made from that cursor position.
/// 
/// In addition the mode of the pointer can be set so that the cursor position automatically
///   increments or set so that it does not this allows for multiple reads of the same pad
///   value, or reads of multi-record values, via an incrementing pointer.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the offset of the pointer
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The value of the offset.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall pointer_getOffset(unsigned int* id, struct Result* result, const int index);

/// Set the offset of the pointer
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param offset The value of the offset.
/// 
aLIBEXPORT void __stdcall pointer_setOffset(unsigned int* id, struct Result* result, const int index, const unsigned short offset);

/// Get the mode of the pointer
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The mode: aPOINTER_MODE_STATIC or aPOINTER_MODE_AUTO_INCREMENT.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall pointer_getMode(unsigned int* id, struct Result* result, const int index);

/// Set the mode of the pointer
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param mode The mode: aPOINTER_MODE_STATIC or aPOINTER_MODE_AUTO_INCREMENT.
/// 
aLIBEXPORT void __stdcall pointer_setMode(unsigned int* id, struct Result* result, const int index, const unsigned char mode);

/// Get the handle to the store.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The handle of the store.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall pointer_getTransferStore(unsigned int* id, struct Result* result, const int index);

/// Set the handle to the store.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param handle The handle of the store.
/// 
aLIBEXPORT void __stdcall pointer_setTransferStore(unsigned int* id, struct Result* result, const int index, const unsigned char handle);

/// Transfer data to the store.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param transferLength The length of the data transfer.
/// 
aLIBEXPORT void __stdcall pointer_initiateTransferToStore(unsigned int* id, struct Result* result, const int index, const unsigned char transferLength);

/// Transfer data from the store.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param transferLength The length of the data transfer.
/// 
aLIBEXPORT void __stdcall pointer_initiateTransferFromStore(unsigned int* id, struct Result* result, const int index, const unsigned char transferLength);

/// Get a char (1 byte) value from the pointer at this object's index, where elements are 1
///   byte long.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The value of a single character (1 byte) stored in the pointer.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall pointer_getChar(unsigned int* id, struct Result* result, const int index);

/// Set a char (1 byte) value to the pointer at this object's element index, where elements
///   are 1 byte long.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param value The single char (1 byte) value to be stored in the pointer.
/// 
aLIBEXPORT void __stdcall pointer_setChar(unsigned int* id, struct Result* result, const int index, const unsigned char value);

/// Get a short (2 byte) value from the pointer at this objects index, where elements are 2
///   bytes long
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The value of a single short (2 byte) stored in the pointer.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall pointer_getShort(unsigned int* id, struct Result* result, const int index);

/// Set a short (2 bytes) value to the pointer at this object's element index, where elements
///   are 2 bytes long.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param value The single short (2 byte) value to be set in the pointer.
/// 
aLIBEXPORT void __stdcall pointer_setShort(unsigned int* id, struct Result* result, const int index, const unsigned short value);

/// Get an int (4 bytes) value from the pointer at this objects index, where elements are 4
///   bytes long
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The value of a single int (4 byte) stored in the pointer.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall pointer_getInt(unsigned int* id, struct Result* result, const int index);

/// Set an int (4 bytes) value from the pointer at this objects index, where elements are 4
///   bytes long
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param value The single int (4 byte) value to be stored in the pointer.
/// 
aLIBEXPORT void __stdcall pointer_setInt(unsigned int* id, struct Result* result, const int index, const unsigned int value);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_POINTER_CCA_H__