/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_RelayClass_CCA.h                                  //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_RELAY_CCA_H__
#define __AUTOGEN_RELAY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup RelayEntity Relay Entity
/// Interface to relay entities on BrainStem modules.
/// Relay entities can be set, and the voltage read.
/// Other capabilities may be available, please see the product datasheet.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Set the enable/disable state.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param enable False or 0 = Disabled, True or 1 = Enabled
/// 
aLIBEXPORT void __stdcall relay_setEnable(unsigned int* id, struct Result* result, const int index, const unsigned char enable);

/// Get the state.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: False or 0 = Disabled, True or 1 = Enabled
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall relay_getEnable(unsigned int* id, struct Result* result, const int index);

/// Get the scaled micro volt value with reference to ground.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: 32 bit signed integer (in micro Volts) based on the boards ground and
///              reference voltages.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
/// \note Not all modules provide 32 bits of accuracy. Refer to the module's datasheet to
///       determine the analog bit depth and reference voltage.
/// 
aLIBEXPORT void __stdcall relay_getVoltage(unsigned int* id, struct Result* result, const int index);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_RELAY_CCA_H__