/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_StoreClass_CCA.h                                  //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_STORE_CCA_H__
#define __AUTOGEN_STORE_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup StoreEntity Store Entity
/// The store provides a flat file system on modules that have storage capacity.
/// Files are referred to as slots and they have simple zero-based numbers for access.
/// Store slots can be used for generalized storage and commonly contain compiled reflex code
///   (files ending in .map) or templates used by the system.
/// Slots simply contain bytes with no expected organization but the code or use of the slot
///   may impose a structure.
/// Stores have fixed indices based on type.
/// Not every module contains a store of each type. Consult the module datasheet for details
///   on which specific stores are implemented, if any, and the capacities of implemented
///   stores.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get slot state.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: true: enabled, false: disabled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// 
aLIBEXPORT void __stdcall store_getSlotState(unsigned int* id, struct Result* result, const int index, const unsigned char slot);

/// Load the slot.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// \param buffer The data.
/// \param bufferLength The data length.
/// 
aLIBEXPORT void __stdcall store_loadSlot(unsigned int* id, struct Result* result, const int index, const unsigned char slot, const unsigned char* buffer, const unsigned short bufferLength);

/// Unload the slot data.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length of data that was unloaded. Unloaded length
///                                    will never be larger than dataLength.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// \param bufferLength The length of buffer buffer in bytes. This is the maximum number of
///        bytes that should be unloaded.
/// \param buffer Byte array that the unloaded data will be placed into.
/// 
aLIBEXPORT void __stdcall store_unloadSlot(unsigned int* id, struct Result* result, const int index, const unsigned char slot, unsigned char* buffer, const unsigned int bufferLength);

/// Enable slot.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// 
aLIBEXPORT void __stdcall store_slotEnable(unsigned int* id, struct Result* result, const int index, const unsigned char slot);

/// Disable slot.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// 
aLIBEXPORT void __stdcall store_slotDisable(unsigned int* id, struct Result* result, const int index, const unsigned char slot);

/// Get the slot capacity.
/// Returns the Capacity of the slot, i.e. The number of bytes it can hold.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The slot capacity.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// 
aLIBEXPORT void __stdcall store_getSlotCapacity(unsigned int* id, struct Result* result, const int index, const unsigned char slot);

/// Get the slot size.
/// The slot size represents the size of the data currently filling the slot in bytes.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The slot size.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param slot The slot number.
/// 
aLIBEXPORT void __stdcall store_getSlotSize(unsigned int* id, struct Result* result, const int index, const unsigned char slot);

/// Gets the current lock state of the slot
/// Allows for write protection on a slot.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filed with the locked state.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param slot The slot number
/// 
aLIBEXPORT void __stdcall store_getSlotLocked(unsigned int* id, struct Result* result, const int index, const unsigned char slot);

/// Sets the locked state of the slot
/// Allows for write protection on a slot.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param slot The slot number
/// \param lock state to be set.
/// 
aLIBEXPORT void __stdcall store_setSlotLocked(unsigned int* id, struct Result* result, const int index, const unsigned char slot, const unsigned char lock);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_STORE_CCA_H__