/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_SystemClass_CCA.h                                 //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_SYSTEM_CCA_H__
#define __AUTOGEN_SYSTEM_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup SystemEntity System Entity
/// The System class provides access to the core settings, configuration and system
///   information of the BrainStem module.
/// The class provides access to the model type, serial number and other static information as
///   well as the ability to set boot reflexes, toggle the user LED, as well as affect module
///   and router addresses etc.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the current address the module uses on the BrainStem network.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The address the module is using on the BrainStem network.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getModule(unsigned int* id, struct Result* result, const int index);

/// Get the base address of the module.
/// Software offsets and hardware offsets are added to this base address to produce the
///   effective module address.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The address the module is using on the BrainStem network.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getModuleBaseAddress(unsigned int* id, struct Result* result, const int index);

/// Set the router address the module uses to communicate with the host and heartbeat to in
///   order to establish the BrainStem network.
/// This setting must be saved and the board reset before the setting becomes active.
/// Warning: changing the router address may cause the module to "drop off" the BrainStem
///   network if the new router address is not in use by a BrainStem module.
/// Please review the BrainStem network fundamentals before modifying the router address.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param address The router address to be used.
/// 
aLIBEXPORT void __stdcall system_setRouter(unsigned int* id, struct Result* result, const int index, const unsigned char address);

/// Get the router address the module uses to communicate with the host and heartbeat to in
///   order to establish the BrainStem network.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The address.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getRouter(unsigned int* id, struct Result* result, const int index);

/// Set the delay between heartbeat packets which are sent from the module.
/// For link modules, these these heartbeat are sent to the host.
/// For non-link modules, these heartbeats are sent to the router address.
/// Interval values are in 25.6 millisecond increments
/// Valid values are 1-255; default is 10 (256 milliseconds).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param interval The desired heartbeat delay.
/// 
aLIBEXPORT void __stdcall system_setHBInterval(unsigned int* id, struct Result* result, const int index, const unsigned char interval);

/// Get the delay between heartbeat packets which are sent from the module.
/// For link modules, these these heartbeat are sent to the host.
/// For non-link modules, these heartbeats are sent to the router address.
/// Interval values are in 25.6 millisecond increments.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current heartbeat delay.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getHBInterval(unsigned int* id, struct Result* result, const int index);

/// Set the system LED state. Most modules have a blue system LED.
/// Refer to the module datasheet for details on the system LED location and color.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param ledOn true: turn the LED on, false: turn LED off.
/// 
aLIBEXPORT void __stdcall system_setLED(unsigned int* id, struct Result* result, const int index, const unsigned char ledOn);

/// Get the system LED state. Most modules have a blue system LED.
/// Refer to the module datasheet for details on the system LED location and color.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: true: LED on, false: LED off.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getLED(unsigned int* id, struct Result* result, const int index);

/// Sets the scaling factor for the brightness of all LEDs on the system.
/// The brightness is set to the ratio of this value compared to 255 (maximum).
/// The colors of each LED may be inconsistent at low brightness levels.
/// Note that if the brightness is set to zero and the settings are saved, then the LEDs will
///   no longer indicate whether the system is powered on.
/// When troubleshooting, the user configuration may need to be manually reset in order to
///   view the LEDs again.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param brightness Brightness value relative to 255
/// 
aLIBEXPORT void __stdcall system_setLEDMaxBrightness(unsigned int* id, struct Result* result, const int index, const unsigned char brightness);

/// Gets the scaling factor for the brightness of all LEDs on the system.
/// The brightness is set to the ratio of this value compared to 255 (maximum).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Brightness value relative to 255
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getLEDMaxBrightness(unsigned int* id, struct Result* result, const int index);

/// Set a store slot to be mapped when the module boots.
/// The boot slot will be mapped after the module boots from powers up, receives a reset
///   signal on its reset input, or is issued a software reset command.
/// Set the slot to 255 to disable mapping on boot.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param slot The slot number in aSTORE_INTERNAL to be marked as a boot slot.
/// 
aLIBEXPORT void __stdcall system_setBootSlot(unsigned int* id, struct Result* result, const int index, const unsigned char slot);

/// Get the store slot which is mapped when the module boots.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The slot number in aSTORE_INTERNAL that is mapped after the module
///              boots.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getBootSlot(unsigned int* id, struct Result* result, const int index);

/// Get the modules firmware version number.
/// The version number is packed into the return value.
/// Utility functions in the aVersion module can unpack the major, minor and patch numbers
///   from the version number which looks like M.m.p.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The build version date code.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getVersion(unsigned int* id, struct Result* result, const int index);

/// Get the modules firmware build number
/// The build number is a unique hash assigned to a specific firmware.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with build.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getBuild(unsigned int* id, struct Result* result, const int index);

/// Get the module's model enumeration.
/// A subset of the possible model enumerations is defined in BrainStem.h under "BrainStem
///   model codes".
/// Other codes are be used by Acroname for proprietary module types.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's model enumeration.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getModel(unsigned int* id, struct Result* result, const int index);

/// Get the module's hardware revision information.
/// The content of the hardware version is specific to each Acroname product and used to
///   indicate behavioral differences between product revisions.
/// The codes are not well defined and may change at any time.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's hardware version information.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getHardwareVersion(unsigned int* id, struct Result* result, const int index);

/// Get the module's serial number.
/// The serial number is a unique 32 bit integer which is usually communicated in hexadecimal
///   format.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's serial number.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getSerialNumber(unsigned int* id, struct Result* result, const int index);

/// Save the system operating parameters to the persistent module flash memory.
/// Operating parameters stored in the system flash will be loaded after the module reboots.
/// Operating parameters include: heartbeat interval, module address, module router address.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_save(unsigned int* id, struct Result* result, const int index);

/// Reset the system.
/// A return value of aErrTimeout indicates a successful reset, as the system resets
///   immediately, which tears down the USB-link immediately, thus preventing an affirmative
///   response.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_reset(unsigned int* id, struct Result* result, const int index);

/// Saves system log events to a slot defined by the module (usually ram slot 0).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_logEvents(unsigned int* id, struct Result* result, const int index);

/// Get the module's accumulated uptime in minutes
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's accumulated uptime in minutes.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getUptime(unsigned int* id, struct Result* result, const int index);

/// Get the module's current temperature in micro-C
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's system temperature in micro-C
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getTemperature(unsigned int* id, struct Result* result, const int index);

/// Get the module's minimum temperature ever recorded in micro-C (uC).
/// This value will persists through a power cycle.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's minimum system temperature in micro-C
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getMinimumTemperature(unsigned int* id, struct Result* result, const int index);

/// Get the module's maximum temperature ever recorded in micro-C (uC).
/// This value will persists through a power cycle.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's maximum system temperature in micro-C
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getMaximumTemperature(unsigned int* id, struct Result* result, const int index);

/// Get the module's input voltage.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's input voltage reported in microvolts.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getInputVoltage(unsigned int* id, struct Result* result, const int index);

/// Get the module's input current.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's input current reported in microamps.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getInputCurrent(unsigned int* id, struct Result* result, const int index);

/// Get the module hardware address offset. This is added to the base address to allow the
///   module address to be configured in hardware.
/// Not all modules support the hardware module address offset. Refer to the module datasheet.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module address offset.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getModuleHardwareOffset(unsigned int* id, struct Result* result, const int index);

/// Set the software address offset.
/// This software offset is added to the module base address, and potentially a module
///   hardware address to produce the final module address.
/// You must save the system settings and restart for this to take effect.
/// Please review the BrainStem network fundamentals before modifying the module address.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param address The address for the module. Value must be even from 0-254.
/// 
aLIBEXPORT void __stdcall system_setModuleSoftwareOffset(unsigned int* id, struct Result* result, const int index, const unsigned char address);

/// Get the software address offset.
/// This software offset is added to the module base address, and potentially a module
///   hardware address to produce the final module address.
/// You must save the system settings and restart for this to take effect.
/// Please review the BrainStem network fundamentals before modifying the module address.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The address for the module. Value must be even from 0-254.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getModuleSoftwareOffset(unsigned int* id, struct Result* result, const int index);

/// Get the router address system setting.
/// This setting may not be the same as the current router address if the router setting was
///   set and saved but no reset has occurred.
/// Please review the BrainStem network fundamentals before modifying the module address.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The address for the module. Value must be even from 0-254.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getRouterAddressSetting(unsigned int* id, struct Result* result, const int index);

/// Enables/Disables the route to me function.
/// This function allows for easy networking of BrainStem modules.
/// Enabling (1) this function will send an I2C General Call to all devices on the network and
///   request that they change their router address to the of the calling device.
/// Disabling (0) will cause all devices on the BrainStem network to revert to their default
///   address.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param enable Enable or disable of the route to me function 1 = enable.
/// 
aLIBEXPORT void __stdcall system_routeToMe(unsigned int* id, struct Result* result, const int index, const unsigned char enable);

/// Reports the amount of power the system has access to and thus how much power can be
///   budgeted to sinking devices.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The available power in milli-Watts (mW, 1 t)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getPowerLimit(unsigned int* id, struct Result* result, const int index);

/// Gets the user defined maximum power limit for the system.
/// Provides mechanism for defining an unregulated power supplies capability.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the power limit in milli-Watts (mW)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getPowerLimitMax(unsigned int* id, struct Result* result, const int index);

/// Sets a user defined maximum power limit for the system.
/// Provides mechanism for defining an unregulated power supplies capability.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param power Limit in milli-Watts (mW) to be set.
/// 
aLIBEXPORT void __stdcall system_setPowerLimitMax(unsigned int* id, struct Result* result, const int index, const unsigned int power);

/// Gets a bit mapped representation of the factors contributing to the power limit.
/// Active limit can be found through PowerDeliverClass::getPowerLimit().
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the state.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getPowerLimitState(unsigned int* id, struct Result* result, const int index);

/// Gets the voltage present at the unregulated port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the voltage in micro-Volts (uV).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getUnregulatedVoltage(unsigned int* id, struct Result* result, const int index);

/// Gets the current passing through the unregulated port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the current in micro-Amps (uA).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getUnregulatedCurrent(unsigned int* id, struct Result* result, const int index);

/// Provides the source of the current power source in use.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with enumerated representation of the source.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getInputPowerSource(unsigned int* id, struct Result* result, const int index);

/// Gets the systems input power behavior.
/// This behavior refers to where the device sources its power from and what happens if that
///   power source goes away.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with an enumerated value representing behavior.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getInputPowerBehavior(unsigned int* id, struct Result* result, const int index);

/// Sets the systems input power behavior.
/// This behavior refers to where the device sources its power from and what happens if that
///   power source goes away.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param behavior An enumerated representation of behavior to be set.
/// 
aLIBEXPORT void __stdcall system_setInputPowerBehavior(unsigned int* id, struct Result* result, const int index, const unsigned char behavior);

/// Gets the input power behavior configuration
/// Certain behaviors use a list of ports to determine priority when budgeting power.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length that was actually received and filled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// 
aLIBEXPORT void __stdcall system_getInputPowerBehaviorConfig(unsigned int* id, struct Result* result, const int index, unsigned int* buffer, const unsigned int bufferLength);

/// Sets the input power behavior configuration
/// Certain behaviors use a list of ports to determine priority when budgeting power.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param buffer Pointer to the start of a c style buffer to be transferred.
/// \param bufferLength Length of the buffer to be transferred.
/// 
aLIBEXPORT void __stdcall system_setInputPowerBehaviorConfig(unsigned int* id, struct Result* result, const int index, const unsigned int* buffer, const unsigned int bufferLength);

/// Gets a user defined name of the device.
/// Helpful for identifying ports/devices in a static environment.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length that was actually received and filled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
/// \param bufferLength Length of the buffer to be filed
/// 
aLIBEXPORT void __stdcall system_getName(unsigned int* id, struct Result* result, const int index, unsigned char* buffer, const unsigned int bufferLength);

/// Sets a user defined name for the device.
/// Helpful for identification when multiple devices of the same type are present in a system.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param buffer Pointer to the start of a c style buffer to be transferred.
/// \param bufferLength Length of the buffer to be transferred.
/// 
aLIBEXPORT void __stdcall system_setName(unsigned int* id, struct Result* result, const int index, const unsigned char* buffer, const unsigned int bufferLength);

/// Resets the device to it factory default configuration.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_resetDeviceToFactoryDefaults(unsigned int* id, struct Result* result, const int index);

/// Gets the link interface configuration.
/// This refers to which interface is being used for control by the device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with an enumerated value representing interface.
///                  \li 0 = Auto= systemLinkAuto
///                  \li 1 = Control Port = systemLinkUSBControl
///                  \li 2 = Hub Upstream Port = systemLinkUSBHub
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getLinkInterface(unsigned int* id, struct Result* result, const int index);

/// Sets the link interface configuration.
/// This refers to which interface is being used for control by the device.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param linkInterface An enumerated representation of interface to be set.
///            - 0 = Auto= systemLinkAuto
///            - 1 = Control Port = systemLinkUSBControl
///            - 2 = Hub Upstream Port = systemLinkUSBHub
/// 
aLIBEXPORT void __stdcall system_setLinkInterface(unsigned int* id, struct Result* result, const int index, const unsigned char linkInterface);

/// Gets any system level errors.
/// Calling this function will clear the current errors. If the error persists it will be set
///   again.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Bit mapped field representing the devices errors
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getErrors(unsigned int* id, struct Result* result, const int index);

/// Gets the firmware protocol features
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Value representing the firmware protocol features
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall system_getProtocolFeatures(unsigned int* id, struct Result* result, const int index);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_SYSTEM_CCA_H__