/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_TemperatureClass_CCA.h                            //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_TEMPERATURE_CCA_H__
#define __AUTOGEN_TEMPERATURE_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup TemperatureEntity Temperature Entity
/// This entity is only available on certain modules, and provides a temperature reading in
///   microcelsius.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the modules temperature in micro-C
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The temperature in micro-Celsius (1 == 1e-6C).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall temperature_getValue(unsigned int* id, struct Result* result, const int index);

/// Get the module's minimum temperature in micro-C since the last power cycle.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's minimum temperature in micro-C
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall temperature_getValueMin(unsigned int* id, struct Result* result, const int index);

/// Get the module's maximum temperature in micro-C since the last power cycle.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The module's maximum temperature in micro-C
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall temperature_getValueMax(unsigned int* id, struct Result* result, const int index);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_TEMPERATURE_CCA_H__