/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_TimerClass_CCA.h                                  //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_TIMER_CCA_H__
#define __AUTOGEN_TIMER_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup TimerEntity Timer Entity
/// The Timer Class provides access to a simple scheduler.
/// The timer can set to fire only once, or to repeat at a certain interval.
/// Additionally, a timer entity can execute custom Reflex routines upon firing.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the currently set expiration time in microseconds.
/// This is not a "live" timer. That is, it shows the expiration time originally set with
///   setExpiration; it does not "tick down" to show the time remaining before expiration.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The timer expiration duration in microseconds.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall timer_getExpiration(unsigned int* id, struct Result* result, const int index);

/// Set the expiration time for the timer entity.
/// When the timer expires, it will fire the associated timer[index]() reflex.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param usecDuration The duration before timer expiration in microseconds.
/// 
aLIBEXPORT void __stdcall timer_setExpiration(unsigned int* id, struct Result* result, const int index, const unsigned int usecDuration);

/// Get the mode of the timer which is either single or repeat mode.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The mode of the time. aTIMER_MODE_REPEAT or aTIMER_MODE_SINGLE.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall timer_getMode(unsigned int* id, struct Result* result, const int index);

/// Set the mode of the timer which is either single or repeat mode.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param mode The mode of the timer. aTIMER_MODE_REPEAT or aTIMER_MODE_SINGLE.
/// 
aLIBEXPORT void __stdcall timer_setMode(unsigned int* id, struct Result* result, const int index, const unsigned char mode);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_TIMER_CCA_H__