/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_UARTClass_CCA.h                                   //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_UART_CCA_H__
#define __AUTOGEN_UART_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup UARTEntity UART Entity
/// A UART is a "Universal Asynchronous Receiver/Transmitter.  Many times referred to as a COM
///   (communication), Serial, or TTY (teletypewriter) port.
/// The UART Class allows the enabling and disabling of the UART data lines.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Enable the UART channel.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param enabled true: enabled, false: disabled.
/// 
aLIBEXPORT void __stdcall uart_setEnable(unsigned int* id, struct Result* result, const int index, const unsigned char enabled);

/// Get the enabled state of the uart.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: true: enabled, false: disabled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getEnable(unsigned int* id, struct Result* result, const int index);

/// Set the UART baud rate.
/// If zero, automatic baud rate selection is used.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param rate baud rate.
/// 
aLIBEXPORT void __stdcall uart_setBaudRate(unsigned int* id, struct Result* result, const int index, const unsigned int rate);

/// Get the UART baud rate.
/// If zero, automatic baud rate selection is used.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer variable to be filled with baud rate.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getBaudRate(unsigned int* id, struct Result* result, const int index);

/// Set the UART protocol.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param protocol An enumeration of serial protocols.
/// 
aLIBEXPORT void __stdcall uart_setProtocol(unsigned int* id, struct Result* result, const int index, const unsigned char protocol);

/// Get the UART protocol.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer to where result is placed.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getProtocol(unsigned int* id, struct Result* result, const int index);

/// Set the index of another UART Entity that should be linked to this UART.
/// 
/// If set to the index of this entity, the channel will not be linked.
/// If set to the index of another UART entity, data will be sent between the two UART
///   entities with no additional processing.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel Index of the UART Entity to link
/// 
aLIBEXPORT void __stdcall uart_setLinkChannel(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Gets the index of the UART Entity that this entity is linked to.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer to where result is placed.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getLinkChannel(unsigned int* id, struct Result* result, const int index);

/// Set the UART stop bit configuration
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param stopBits Stop Bits of UART Channel. Allowed options:
///            - uartStopBits_1_Value
///            - uartStopBits_1p5_Value
///            - uartStopBits_2_Value
/// 
aLIBEXPORT void __stdcall uart_setStopBits(unsigned int* id, struct Result* result, const int index, const unsigned char stopBits);

/// Set the UART stop bit configuration
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer to where result is placed. Possible values:
///                  \li uartStopBits_1_Value
///                  \li uartStopBits_1p5_Value
///                  \li uartStopBits_2_Value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getStopBits(unsigned int* id, struct Result* result, const int index);

/// Set the UART parity.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param parity Parity of UART Channel. Allowed options:
///            - uartParity_None_Value
///            - uartParity_Odd_Value
///            - uartParity_Even_Value
///            - uartParity_Mark_Value
///            - uartParity_Space_Value
/// 
aLIBEXPORT void __stdcall uart_setParity(unsigned int* id, struct Result* result, const int index, const unsigned char parity);

/// Get the UART parity.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer variable to be filled with value. Possible values:
///                  \li uartParity_None_Value
///                  \li uartParity_Odd_Value
///                  \li uartParity_Even_Value
///                  \li uartParity_Mark_Value
///                  \li uartParity_Space_Value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getParity(unsigned int* id, struct Result* result, const int index);

/// Set the number of bits per character
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param dataBits Data Bits of UART Channel.
/// 
aLIBEXPORT void __stdcall uart_setDataBits(unsigned int* id, struct Result* result, const int index, const unsigned char dataBits);

/// Get the number of bits per character
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer to where result is placed.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getDataBits(unsigned int* id, struct Result* result, const int index);

/// Set the UART flow control configuration
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param flowControl Flow Control of UART Channel as a bitmask. Allowed bits:
///            - uartFlowControl_RTS_CTS_Bit
///            - uartFlowControl_DSR_DTR_Bit
///            - uartFlowControl_XON_XOFF_Bit
/// 
aLIBEXPORT void __stdcall uart_setFlowControl(unsigned int* id, struct Result* result, const int index, const unsigned char flowControl);

/// Set the UART flow control configuration
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer to bitmask where result is placed. Possible bits:
///                  \li uartFlowControl_RTS_CTS_Bit
///                  \li uartFlowControl_DSR_DTR_Bit
///                  \li uartFlowControl_XON_XOFF_Bit
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getFlowControl(unsigned int* id, struct Result* result, const int index);

/// Returns a bitmask containing a list of protocols that this UART entity is allowed to
///   select.
/// This does not guarantee that selecting a protocol with "setProtocol" will have an
///   available resource.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Bitmask containing list of protocols that may be selected.
///              The value of the uartProtocol is mapped to the bit index (e.g.
///              uartProtocol_Undefined is bit 0, uartProtocol_ExtronResponder_Value is bit 1,
///              etc.)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getCapableProtocols(unsigned int* id, struct Result* result, const int index);

/// Returns a bitmask containing a list of protocols that this UART entity is capable of
///   selecting, and has an available protocol resource to assign.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Bitmask containing list of protocols that are available to select.
///              The value of the uartProtocol is mapped to the bit index (e.g.
///              uartProtocol_Undefined is bit 0, uartProtocol_ExtronResponder_Value is bit 1,
///              etc.)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall uart_getAvailableProtocols(unsigned int* id, struct Result* result, const int index);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_UART_CCA_H__