/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_USBClass_CCA.h                                    //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2025 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_USB_CCA_H__
#define __AUTOGEN_USB_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup USBEntity USB Entity
/// The USB class provides methods to interact with a USB hub and USB switches.
/// Different USB hub products have varying support; check the datasheet to understand the
///   capabilities of each product.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Enable both power and data lines for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setPortEnable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Disable both power and data lines for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setPortDisable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Enable the only the data lines for a port without changing the state of the power line.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setDataEnable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Disable only the data lines for a port without changing the state of the power line.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setDataDisable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Enable the only the data lines for a port without changing the state of the power line,
///   Hi-Speed (2.0) only.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setHiSpeedDataEnable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Disable only the data lines for a port without changing the state of the power line, Hi-
///   Speed (2.0) only.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setHiSpeedDataDisable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Enable the only the data lines for a port without changing the state of the power line,
///   SuperSpeed (3.0) only.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setSuperSpeedDataEnable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Disable only the data lines for a port without changing the state of the power line,
///   SuperSpeed (3.0) only.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setSuperSpeedDataDisable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Enable only the power line for a port without changing the state of the data lines.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setPowerEnable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Disable only the power line for a port without changing the state of the data lines.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_setPowerDisable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the current through the power line for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB channel current in micro-amps (1 == 1e-6A).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getPortCurrent(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the voltage on the power line for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB channel voltage in microvolts (1 == 1e-6V).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getPortVoltage(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get a bit mapped representation of the hubs mode; see the product datasheet for mode
///   mapping and meaning.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB hub mode.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall usb_getHubMode(unsigned int* id, struct Result* result, const int index);

/// Set a bit mapped hub state; see the product datasheet for state mapping and meaning.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param mode The USB hub mode.
/// 
aLIBEXPORT void __stdcall usb_setHubMode(unsigned int* id, struct Result* result, const int index, const unsigned int mode);

/// Clear the error status for the given port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The port to clear error status for.
/// 
aLIBEXPORT void __stdcall usb_clearPortErrorStatus(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the upstream switch mode for the USB upstream ports. Returns auto, port 0 or port 1.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The Upstream port mode.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall usb_getUpstreamMode(unsigned int* id, struct Result* result, const int index);

/// Set the upstream switch mode for the USB upstream ports. Values are usbUpstreamModeAuto,
///   usbUpstreamModePort0, usbUpstreamModePort1, and usbUpstreamModeNone.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param mode The Upstream port mode.
/// 
aLIBEXPORT void __stdcall usb_setUpstreamMode(unsigned int* id, struct Result* result, const int index, const unsigned char mode);

/// Get the upstream switch state for the USB upstream ports.
/// Returns 2 if no ports plugged in, 0 if the mode is set correctly and a cable is plugged
///   into port 0, and 1 if the mode is set correctly and a cable is plugged into port 1.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The Upstream port state.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall usb_getUpstreamState(unsigned int* id, struct Result* result, const int index);

/// Set the inter-port enumeration delay in milliseconds.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param ms_delay Millisecond delay in 100mS increments (100, 200, 300 etc.)
/// 
aLIBEXPORT void __stdcall usb_setEnumerationDelay(unsigned int* id, struct Result* result, const int index, const unsigned int ms_delay);

/// Get the inter-port enumeration delay in milliseconds.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Millisecond delay in 100mS increments (100, 200, 300 etc.)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall usb_getEnumerationDelay(unsigned int* id, struct Result* result, const int index);

/// Set the current limit for the port.
/// If the set limit is not achievable, devices will round down to the nearest available
///   current limit setting.
/// This setting can be saved with a stem.system.save() call.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel USB downstream channel to limit.
/// \param microamps The current limit setting.
/// 
aLIBEXPORT void __stdcall usb_setPortCurrentLimit(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned int microamps);

/// Get the current limit for the port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current limit setting.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel USB downstream channel to limit.
/// 
aLIBEXPORT void __stdcall usb_getPortCurrentLimit(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Set the mode for the Port.
/// The mode is a bitmapped representation of the capabilities of the usb port.
/// These capabilities change for each of the BrainStem devices which implement the usb
///   entity.
/// See your device reference page for a complete list of capabilities.
/// Some devices use a common bit mapping for port mode, as sub-definitions of usbPortMode.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel USB downstream channel to set the mode on.
/// \param mode The port mode setting as packed bit field.
/// 
aLIBEXPORT void __stdcall usb_setPortMode(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned int mode);

/// Get the current mode for the Port.
/// The mode is a bitmapped representation of the capabilities of the usb port.
/// These capabilities change for each of the BrainStem devices which implement the usb
///   entity.
/// See your device reference page for a complete list of capabilities.
/// Some devices use a common bit mapping for port mode, as sub-definitions of usbPortMode.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The port mode setting.
///              Mode will be filled with the current setting.
///              Mode bits that are not used will be marked as don't care.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel USB downstream channel.
/// 
aLIBEXPORT void __stdcall usb_getPortMode(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the current State for the Port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The port mode setting.
///              Mode will be filled with the current setting.
///              Mode bits that are not used will be marked as don't care.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel USB downstream channel.
/// 
aLIBEXPORT void __stdcall usb_getPortState(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the current error for the Port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The port mode setting.
///              Mode will be filled with the current setting.
///              Mode bits that are not used will be marked as don't care.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel USB downstream channel.
/// 
aLIBEXPORT void __stdcall usb_getPortError(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Set the upstream boost mode.
/// Boost mode increases the drive strength of the USB data signals (power signals are not
///   changed).
/// Boosting the data signal strength may help to overcome connectivity issues when using long
///   cables or connecting through "pogo" pins.
/// Possible modes are 0 - no boost, 1 - 4% boost, 2 - 8% boost, 3 - 12% boost.
/// This setting is not applied until a stem.system.save() call and power cycle of the hub.
/// Setting is then persistent until changed or the hub is reset.
/// After reset, default value of 0% boost is restored.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param setting Upstream boost setting 0, 1, 2, or 3.
/// 
aLIBEXPORT void __stdcall usb_setUpstreamBoostMode(unsigned int* id, struct Result* result, const int index, const unsigned char setting);

/// Set the downstream boost mode.
/// Boost mode increases the drive strength of the USB data signals (power signals are not
///   changed).
/// Boosting the data signal strength may help to overcome connectivity issues when using long
///   cables or connecting through "pogo" pins.
/// Possible modes are 0 - no boost, 1 - 4% boost, 2 - 8% boost, 3 - 12% boost.
/// This setting is not applied until a stem.system.save() call and power cycle of the hub.
/// Setting is then persistent until changed or the hub is reset.
/// After reset, default value of 0% boost is restored.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param setting Downstream boost setting 0, 1, 2, or 3.
/// 
aLIBEXPORT void __stdcall usb_setDownstreamBoostMode(unsigned int* id, struct Result* result, const int index, const unsigned char setting);

/// Get the upstream boost mode.
/// Possible modes are 0 - no boost, 1 - 4% boost, 2 - 8% boost, 3 - 12% boost.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current Upstream boost setting 0, 1, 2, or 3.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall usb_getUpstreamBoostMode(unsigned int* id, struct Result* result, const int index);

/// Get the downstream boost mode.
/// Possible modes are 0 - no boost, 1 - 4% boost, 2 - 8% boost, 3 - 12% boost.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current Downstream boost setting 0, 1, 2, or 3.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall usb_getDownstreamBoostMode(unsigned int* id, struct Result* result, const int index);

/// Get the current data transfer speed for the downstream port.
/// The data speed can be Hi-Speed (2.0) or SuperSpeed (3.0) depending on what the downstream
///   device attached is using
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Filled with the current port data speed
///                  \li N/A: usbDownstreamDataSpeed_na = 0
///                  \li Hi Speed: usbDownstreamDataSpeed_hs = 1
///                  \li SuperSpeed: usbDownstreamDataSpeed_ss = 2
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel USB downstream channel to check.
/// 
aLIBEXPORT void __stdcall usb_getDownstreamDataSpeed(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Sets the connect mode of the switch.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// \param mode The connect mode
///            - usbManualConnect = 0
///            - usbAutoConnect = 1
/// 
aLIBEXPORT void __stdcall usb_setConnectMode(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned char mode);

/// Gets the connect mode of the switch.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The current connect mode
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getConnectMode(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Set Enable/Disable on the CC1 line.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel USB channel.
/// \param enable State to be set
///            - Disabled: 0
///            - Enabled: 1
/// 
aLIBEXPORT void __stdcall usb_setCC1Enable(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned char enable);

/// Get Enable/Disable on the CC1 line.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: State to be filled
///                  \li Disabled: 0
///                  \li Enabled: 1
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel USB channel.
/// 
aLIBEXPORT void __stdcall usb_getCC1Enable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Set Enable/Disable on the CC2 line.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel USB channel.
/// \param enable State to be filled
///            - Disabled: 0
///            - Enabled: 1
/// 
aLIBEXPORT void __stdcall usb_setCC2Enable(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned char enable);

/// Get Enable/Disable on the CC2 line.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: State to be filled
///                  \li Disabled: 0
///                  \li Enabled: 1
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel USB channel.
/// 
aLIBEXPORT void __stdcall usb_getCC2Enable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the current through the CC1 for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB channel current in micro-amps (1 == 1e-6A).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getCC1Current(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the current through the CC2 for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB channel current in micro-amps (1 == 1e-6A).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getCC2Current(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the voltage of CC1 for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB channel voltage in micro-volts (1 == 1e-6V).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getCC1Voltage(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the voltage of CC2 for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB channel voltage in micro-volts (1 == 1e-6V).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getCC2Voltage(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Enable/Disable only the SBU1/2 based on the configuration of the usbPortMode settings.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// \param enable The state to be set
///        - Disabled: 0
///        - Enabled: 1
/// 
aLIBEXPORT void __stdcall usb_setSBUEnable(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned char enable);

/// Get the Enable/Disable status of the SBU
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The enable/disable status of the SBU
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getSBUEnable(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Set Cable flip. This will flip SBU, CC and SS data lines.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// \param enable The state to be set The state to be set
///            - Disabled: 0
///            - Enabled: 1
/// 
aLIBEXPORT void __stdcall usb_setCableFlip(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned char enable);

/// Get Cable flip setting.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The enable/disable status of cable flip.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getCableFlip(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Set USB Alt Mode Configuration.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel
/// \param configuration The USB configuration to be set for the given channel.
/// 
aLIBEXPORT void __stdcall usb_setAltModeConfig(unsigned int* id, struct Result* result, const int index, const unsigned char channel, const unsigned int configuration);

/// Get USB Alt Mode Configuration.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB configuration for the given channel.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel
/// 
aLIBEXPORT void __stdcall usb_getAltModeConfig(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the voltage of SBU1 for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB channel voltage in micro-volts (1 == 1e-6V).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getSBU1Voltage(unsigned int* id, struct Result* result, const int index, const unsigned char channel);

/// Get the voltage of SBU2 for a port.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The USB channel voltage in micro-volts (1 == 1e-6V).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param channel The USB sub channel.
/// 
aLIBEXPORT void __stdcall usb_getSBU2Voltage(unsigned int* id, struct Result* result, const int index, const unsigned char channel);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_USB_CCA_H__