﻿using System;
using System.Collections.Generic;
using System.Threading;

using Acroname.BrainStem2CLI;

namespace BrainStem2CLI_PortMapping
{
    class Program
    {
        //Helper function for printing error text. 
        static void handlePortMappingError(aErr err)
        {
            if (err == aErr.aErrParam)
            {
                Console.WriteLine("One of the parameters you passed in is not valid.\n");
            }
            else if (err == aErr.aErrMemory)
            {
                Console.WriteLine("Device list does not have enough room.\n");
            }
            else if (err == aErr.aErrNotFound)
            {
                Console.WriteLine("No Acroname devices were found.\n");
            }
            else { Console.WriteLine("Unknown error case: {0}\n", err); }
        }


        static void Main(string[] args)
        {
            Console.WriteLine("Searching for downstream devices.");

            PortMapping map = new PortMapping();

            if (map.lastError == aErr.aErrNone)
            {
                for (int x = 0; x < map.deviceList.Length; x++)
                {
                    Console.WriteLine("Hub SN: 0x{0, 0:X8}", map.deviceList[x].hubSerialNumber);
                    Console.WriteLine("Port: {0}", map.deviceList[x].hubPort);
                    Console.WriteLine("\t-Speed: {0}", map.deviceList[x].speed);
                    Console.WriteLine("\t-VendorID: 0x{0, 0:X4}", map.deviceList[x].idVendor);
                    Console.WriteLine("\t-ProductID: 0x{0, 0:X4}", map.deviceList[x].idProduct);
                    Console.WriteLine("\t-Serial Number: {0}", map.deviceList[x].serialNumber);
                    Console.WriteLine("\t-Product Name: {0}", map.deviceList[x].productName);
                    Console.WriteLine("\t-Manufacturer: {0}", map.deviceList[x].manufacturer);
                    Console.WriteLine("\n");
                }
            }
            else { handlePortMappingError(map.lastError); }


            Console.WriteLine("Press \"Enter\" to search for downstream devices again.");
            Console.ReadLine();
            aErr err = map.update(); //request update.


            if (err == aErr.aErrNone) //map.lastError can also be used.
            {
                for (int x = 0; x < map.deviceList.Length; x++)
                {
                    Console.WriteLine("Hub SN: 0x{0, 0:X8}", map.deviceList[x].hubSerialNumber);
                    Console.WriteLine("Port: {0}", map.deviceList[x].hubPort);
                    Console.WriteLine("\t-Speed: {0}", map.deviceList[x].speed);
                    Console.WriteLine("\t-VendorID: 0x{0, 0:X4}", map.deviceList[x].idVendor);
                    Console.WriteLine("\t-ProductID: 0x{0, 0:X4}", map.deviceList[x].idProduct);
                    Console.WriteLine("\t-Serial Number: {0}", map.deviceList[x].serialNumber);
                    Console.WriteLine("\t-Product Name: {0}", map.deviceList[x].productName);
                    Console.WriteLine("\t-Manufacturer: {0}", map.deviceList[x].manufacturer);
                    Console.WriteLine("\n");
                }
            }
            else { handlePortMappingError(err); }

        }
    }
}
