﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

using Acroname.BrainStem2CLI;

namespace BrainStem2CLI_USBCSwitch
{
    class Program
    {
        static void Main(string[] args)
        {

            Console.WriteLine("Creating a USBCSwitch module");
            USBCSwitch cSwitch = new USBCSwitch();

            //This will be used to convert voltage and current values from micro 
            //volts/amps to their bas units.
            const double MICRO_TO_BASE_UNITS = 1000000.0;

            aErr err = aErr.aErrNone;

            //Supplying a serial number of 0 will result in the device connecting
            //to the first USBCSwitch the function finds.
            err = cSwitch.module.discoverAndConnect(m_linkType.USB, 0);

            if (err != aErr.aErrNone)
            {
                Console.WriteLine("Error connecting to device: {0}", err);
                Console.WriteLine("Press enter to exit");
                Console.ReadLine();
                System.Environment.Exit(1);
            }
            else {  Console.WriteLine("Successfully connected to BrainStem module\n"); }

            //Cycle through each mux channel and aquire the Port Voltage and Current
            Console.WriteLine("Cycling through all Mux channels and aquiring data.");
            cSwitch.usb.setPortEnable(1);
            cSwitch.mux.setEnable(0);
            for (byte i = 0; i < 4; i++)
            { 
                Console.WriteLine("Mux Channel: {0} ...Waiting for port to stabilize", i);

                cSwitch.mux.setChannel(i);
                cSwitch.mux.setEnable(1);
                Thread.Sleep(2000);          //Allow port to stabalize

                int value = 0;

                //Note:  There is only 1 USB channel and there are 4 mux channels.
                //       Mux channels go through the same USB channel
                err = cSwitch.mux.getChannelVoltage(i, ref value);
                Console.WriteLine("\tMux Voltage:     {0,10:F6} VDC,  \tError: {1}", value / MICRO_TO_BASE_UNITS, err);

                err = cSwitch.usb.getPortVoltage(0, ref value);
                Console.WriteLine("\tUSB Voltage:     {0,10:F6} VDC,  \tError: {1}", value / MICRO_TO_BASE_UNITS, err);

                err = cSwitch.usb.getPortCurrent(0, ref value);
                Console.WriteLine("\tUSB Current:     {0,10:F6} Amps, \tError: {1}", value / MICRO_TO_BASE_UNITS, err);

                err = cSwitch.usb.getCC1Voltage(0, ref value);
                Console.WriteLine("\tUSB CC1 Voltage: {0,10:F6} VDC,  \tError: {1}", value / MICRO_TO_BASE_UNITS, err);

                err = cSwitch.usb.getCC1Current(0, ref value);
                Console.WriteLine("\tUSB CC1 Current: {0,10:F6} Amps, \tError: {1}", value / MICRO_TO_BASE_UNITS, err);

                err = cSwitch.usb.getCC2Voltage(0, ref value);
                Console.WriteLine("\tUSB CC2 Voltage: {0,10:F6} VDC   \tError: {1}", value / MICRO_TO_BASE_UNITS, err);

                err = cSwitch.usb.getCC2Current(0, ref value);
                Console.WriteLine("\tUSB CC2 Current: {0,10:F6} Amps, \tError: {1}", value / MICRO_TO_BASE_UNITS, err);

                cSwitch.mux.setEnable(0); //Disable mux for next iteration
                Console.WriteLine("");
            }

            //Turning port back on so the switch isn't left in a none working state.
            cSwitch.mux.setChannel(0);
            cSwitch.mux.setEnable(1);

            Console.WriteLine("Disconnecting from USBCSwitch module");
            cSwitch.module.disconnect();

            Console.WriteLine("Press enter to exit");
            Console.ReadLine();

        }
    }
}
