﻿using System;
using System.Threading;

using Acroname.BrainStem2CLI;

namespace BrainStem2CLI_USBHub3c
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Creating USBHub3c module");
            USBHub3c stem = new USBHub3c();

            //Supplying a serial number of 0 will result in the device connecting
            //to the first USBHub3c the function finds.
            aErr err = stem.module.discoverAndConnect(m_linkType.USB, 0);

            if (err != aErr.aErrNone)
            {
                Console.WriteLine("Error connecting to device: {0}", err);
                Console.WriteLine("Press enter to exit");
                Console.ReadLine();
                System.Environment.Exit(1);
            }
            else
            {
                Console.WriteLine("Successfully connected to BrainStem module\n");
            }

            byte upstreamPort = 8;
            err = stem.hub.getUpstream(ref upstreamPort);
            if (err == aErr.aErrNone)
            {
                Console.WriteLine("The current upstream port is: {0}", upstreamPort);
            }

            Console.WriteLine("\nDisabling all ports");
            for (byte portNum = 0; portNum < 8; portNum++)
            {
                if (portNum == upstreamPort)
                {
                    Console.WriteLine("Skipping upstream Port.");
                }
                else if (portNum == 6)
                {
                    Console.WriteLine("The Control port is always enabled");
                }
                else if (portNum == 7)
                {
                    Console.WriteLine("The Power-C port is always enabled");
                }
                else
                {
                    err = stem.hub.port[portNum].setEnabled(0);
                    Console.WriteLine("Disabling Port {0} Error: {1}",portNum, err);
                }
                Thread.Sleep(400);
            }

            Console.WriteLine("\nEnabling all ports");
            for (byte portNum = 0; portNum < 8; portNum++)
            {
                if (portNum == upstreamPort)
                {
                    Console.WriteLine("Skipping upstream Port.");
                }
                else if (portNum == 6)
                {
                    Console.WriteLine("The Control port is always enabled");
                }
                else if (portNum == 7)
                {
                    Console.WriteLine("The Power-C port is always enabled");
                }
                else
                {
                    err = stem.hub.port[portNum].setEnabled(1);
                    Console.WriteLine("Enabling Port {0} Error: {1}", portNum, err);
                }
                Thread.Sleep(400);
            }

            //Voltage and Current
            Console.WriteLine("\nGetting VBus and VConn Voltage and Current");
            Console.WriteLine("Note: When in PD Mode voltage is only present after successful");
            Console.WriteLine("      negotiation with a device.");
            for (byte portNum = 0; portNum < 8; portNum++)
            {
                Int32 vBusVoltage = 0;
                Int32 vBusCurrent = 0;
                Int32 vConnVoltage = 0;
                Int32 vConnCurrent = 0;

                Console.WriteLine("\nPort: {0}", portNum);

                err = stem.hub.port[portNum].getVbusVoltage(ref vBusVoltage);
                Console.WriteLine("VBus Voltage: {0:0.00}, Error: {1}", vBusVoltage / 1000000.0, err);

                err = stem.hub.port[portNum].getVbusCurrent(ref vBusCurrent);
                Console.WriteLine("VBus Current: {0:0.00}, Error: {1}", vBusCurrent / 1000000.0, err);

                if (portNum != 7)
                {
                    err = stem.hub.port[portNum].getVconnVoltage(ref vConnVoltage);
                    Console.WriteLine("VConn Voltage: {0:0.00}, Error: {1}", vConnVoltage / 1000000.0, err);

                    err = stem.hub.port[portNum].getVconnCurrent(ref vConnCurrent);
                    Console.WriteLine("VConn Current: {00:0.00}, Error: {1}", vConnCurrent / 1000000.0, err);
                }
                else { Console.WriteLine("The Power-C port does not have VConn measurements."); }
            }

            Console.WriteLine("\nDisconnecting from BrainStem Module");
            err = stem.module.disconnect();

            Console.WriteLine("Press enter to exit");
            Console.ReadLine();
        }
    }
}
