import argparse
import sys


class CustomArgumentParser(argparse.ArgumentParser):
    def __init__(self, argv=None, **kwargs):
        super().__init__(**kwargs)
        self.argv = argv if argv is not None else sys.argv[1:]


        self.add_argument("-d", "--device", help="Acroname Device Serial Number", type=self.auto_int, metavar='', default=0)
        self.add_argument("-p", "--port", help="Port to send the request on.", required=True, type=int, metavar='')
        self.add_argument("-r", "--request", help="The BrainStem Power Delivery request to send", required=True, type=int, metavar='')
        self.add_argument("-s", "--sop", help="SOP Selection: SOP`Debug(3), SOP``Debug(4)", required=False, type=int, metavar='', choices={0,1,2,3,4}, default=0)
        
        self.parsed_args = self.parse_args(self.argv[1:])
        self.port = self.parsed_args.port
        self.request = self.parsed_args.request
        self.sn = self.parsed_args.device
        self.sop = self.parsed_args.sop

    def print_example_usage(self):

        EXAMPLE_USAGE = [ \
        (""), \
        ("Example Usage:"), \
        ("    \"%s -p 2 -r 14\" - Requests \"pdRequestBatteryCapabilities\" on the given port"  % (self.argv[0])), \
        ("    \"%s -p 3 -r 15\" - Requests \"pdRequestBatteryStatus\" on the given port"  % (self.argv[0])), \
        ("    \"%s -p 4 -r 16\" - Requests \"pdRequestManufacturerInfoSop\" on the given port"  % (self.argv[0])), \
        ]

        for usage in EXAMPLE_USAGE:
            print(usage)

    def print_help(self):
        super().print_help()
        self.print_example_usage()

    @staticmethod
    def auto_int(x):
        # Automatically detect the base (hex if prefixed with '0x', decimal otherwise)
        return int(x, 0)

