# RDO Test CLI

This example is designed to test Fixed PDOs of known USB PD power supplies. 

The test validates:
- PDO values reported by the connected power supply match expected values
- RDO requests are accepted and result in the expected voltage levels

Load testing of the PDOs is left as an exercise to the reader.

## Supported Power Supplies

| Power Supply | Voltage Levels |
|--------------|----------------|
| Nekteck | 5V, 9V, 15V, 20V |
| HKY100W | 5V, 9V, 12V, 15V, 20V |
| Apple61W | 5V, 9V, 15V, 20V |
| Apple96W | 5V, 9V, 15V, 20V |
| Apple140W | 5V, 9V, 15V, 20V |
| Samsung45W | 5V, 9V, 15V, 20V |
| Samsung25W | 5V, 9V |
| PD45W | 5V, 9V, 15V, 20V |

> **Note:** Additional power supplies can be added by modifying the `POWER_SUPPLY_CONFIGS` dictionary in `power_supply_configs.py`.

## Hardware Setup

> **Note:** Configuration assumes a device with its default settings. If your device has been significantly changed from the default it might be worthwhile doing a factory reset.

- **Upstream connection:** "Port 0" connected to host
- **Power supply:** 100W USB-C power supply connected to "Power C" port or an Unregulated connection.
- **Device under test:** PD power supply connected to the test port.

> **Note:** If the DUT power supply is >= the "Power Supply" then an unregulated connection will be required for best results. 

## Software Setup

1. Create a virtual environment:
   ```bash
   python -m venv venv
   ```

2. Activate the virtual environment:
   ```bash
   # macOS/Linux
   source venv/bin/activate
   
   # Windows
   venv\Scripts\activate
   ```

3. Install BrainStem:
   ```bash
   pip install brainstem
   ```

## Example Usage

**Detailed Help:**
```bash
python rdo_test_cli.py --help
```

**Extended Help (from README):**
```bash
python rdo_test_cli.py --help_extended
```

**Test HKY power supply on port 5:**
```bash
python rdo_test_cli.py --test_port 5 --dut HKY100W
```

**Test Nekteck power supply on port 4:**
```bash
python rdo_test_cli.py --test_port 4 --dut Nekteck
```

**Test PD45W power supply on port 3:**
```bash
python rdo_test_cli.py --test_port 3 --dut PD45W
```

**Connect to a specific device by serial number:**
```bash
python rdo_test_cli.py --test_port 5 --dut HKY100W --sn 0x12345678
```

## Exit Codes

| Code | Name | Description |
|------|------|-------------|
| 0 | SUCCESS | All tests passed |
| 1 | CONNECTION_ERROR | Failed to connect to device |
| 2 | CAPABILITY_CHECK_FAILED | Device does not support required capabilities |
| 3 | PDO_TEST_FAILED | One or more PDO tests failed |
| 4 | RDO_TEST_FAILED | One or more RDO tests failed |
| 5 | PORT_DISABLE_FAILED | Failed to disable port |
| 6 | PORT_ENABLE_FAILED | Failed to enable port |

## Adding New Power Supplies

To add support for a new power supply:

1. Connect the power supply and run the script with an existing DUT configuration
2. Note the actual PDO values reported in the output
3. Use HubTool to find:
   - `KEY_EXPECTED_HOST_PDOS_VOLTAGE`: Look at "Power Data Object: Remote Source" and convert voltage to microvolts (µV)
   - `KEY_EXPECTED_RDOS`: Select the "Object Position" for each index and copy the "Raw" value
4. Add a new entry to `POWER_SUPPLY_CONFIGS` in `power_supply_configs.py`

> **Note:** RDOs can be created programmatically, but this requires a deep understanding of the PD protocol and is beyond the scope of this example.
