# Power Supply Configurations for RDO Testing
#
# This file contains the expected PDO and RDO values for various power supplies.
# Add new power supply configurations here.

# Dictionary key constants
KEY_EXPECTED_HOST_PDOS = "EXPECTED_HOST_PDOS"
KEY_EXPECTED_HOST_PDOS_VOLTAGE = "EXPECTED_HOST_PDOS_VOLTAGE"
KEY_EXPECTED_RDOS = "EXPECTED_RDOS"

# Power supply configurations
# KEY_EXPECTED_HOST_PDOS can be found by in HubTool (versions >= 2.12.1) for a given port under the "Raw" column of "Power Data Object: Remote Source".
# KEY_EXPECTED_HOST_PDOS_VOLTAGE can be found in HubTool by looking at "Voltage"column of "Power Data Object: Remote Source". Then converting the voltage to mV.
# KEY_EXPECTED_RDOS can be found in HubTool by selecting the "Object Position" for each index and then copying the "Raw" value.
# Note: RDO's can be created programmatically, but require a deep understanding of the PD protocol and is beyond the scope of this example.
POWER_SUPPLY_CONFIGS = {
    # Original 100W power supply that shipped with the USBHub3c
    "Nekteck": {
        KEY_EXPECTED_HOST_PDOS: [0x0A01912C, 0x0002D12C, 0x0004B12C, 0x000641F4],
        KEY_EXPECTED_HOST_PDOS_VOLTAGE: [5000000, 9000000, 15000000, 20000000],
        KEY_EXPECTED_RDOS: [0x13819064, 0x2384B12C, 0x3384B12C, 0x438384E1]
    },
    # Current 100W power supply that ships with the USBHub3c
    "HKY100W": {
        KEY_EXPECTED_HOST_PDOS: [0x0B01912C, 0x0002D12C, 0x0003C12C, 0x0004B12C, 0x000641F4],
        KEY_EXPECTED_HOST_PDOS_VOLTAGE: [5000000, 9000000, 12000000, 15000000, 20000000],
        KEY_EXPECTED_RDOS: [0x1384B12C, 0x2384B12C, 0x3384B12C, 0x4383B12C, 0x5387D1F4]
    },
    # Apple 61W Power Supply brick.
    "Apple61W": {
        KEY_EXPECTED_HOST_PDOS: [0x0801912C, 0x0002D12C, 0x0004B12C, 0x0006412C],
        KEY_EXPECTED_HOST_PDOS_VOLTAGE: [5000000, 9000000, 15000000, 20000000],
        KEY_EXPECTED_RDOS: [0x13819064, 0x2384B12C, 0x3384B12C, 0x4384B12C]
    },
    # Apple 96W Power Supply brick.
    "Apple96W": {
        KEY_EXPECTED_HOST_PDOS: [0x0801912C, 0x0002D12C, 0x0004B12C, 0x000641D6],
        KEY_EXPECTED_HOST_PDOS_VOLTAGE: [5000000, 9000000, 15000000, 20000000],
        KEY_EXPECTED_RDOS: [0x1384B12C, 0x2384B12C, 0x3384B12C, 0x438759D6]
    },
    # Apple 140W Power Supply brick.
    "Apple140W": {
        KEY_EXPECTED_HOST_PDOS: [0x0981912C, 0x0002D12C, 0x0004B12C, 0x000641D6],
        KEY_EXPECTED_HOST_PDOS_VOLTAGE: [5000000, 9000000, 15000000, 20000000],
        KEY_EXPECTED_RDOS: [0x13819064, 0x2384B12C, 0x3384B12C, 0x438759D6]
    },
    # Samsung 45W Power Supply brick.
    "Samsung45W": {
        KEY_EXPECTED_HOST_PDOS: [0x0A01912C, 0x0002D12C, 0x0004B12C, 0x000640E1],
        KEY_EXPECTED_HOST_PDOS_VOLTAGE: [5000000, 9000000, 15000000, 20000000],
        KEY_EXPECTED_RDOS: [0x13819064, 0x2384B12C, 0x3384B12C, 0x438384E1]
    },
    # Samsung 25W Power Supply brick.
    "Samsung25W": {
        KEY_EXPECTED_HOST_PDOS: [0x0A01912C, 0x0002D015],
        KEY_EXPECTED_HOST_PDOS_VOLTAGE: [5000000, 9000000],
        KEY_EXPECTED_RDOS: [0x13819064, 0x23845515]
    },
    # Generic 45W Power Supply brick.
    "PD45W": {
        KEY_EXPECTED_HOST_PDOS: [0x0801912C, 0x0002D12C, 0x0004B12C, 0x000640E1],
        KEY_EXPECTED_HOST_PDOS_VOLTAGE: [5000000, 9000000, 15000000, 20000000],
        KEY_EXPECTED_RDOS: [0x13819064, 0x2384B12C, 0x3384B12C, 0x438384E1]
    },

    #TODO: Add more DUTs here.
}


