# USB Speed Test CLI

This script tests USB device enumeration speeds across multiple ports by progromatically limiting the max data rate of the USB hub.

The test validates that devices enumerate at the expected speeds by comparing:
- The speed reported by the hub
- The speed reported by the operating system
- The expected speed for the current data rate configuration

## Tested Configurations

| Speed | Description |
|-------|-------------|
| 10G | SuperSpeed Plus |
| 5G | SuperSpeed |
| 480M | High Speed |
| 12M | Full Speed |
| 1.5M | Low Speed (currently unsupported on Acroname products) |

## Hardware Setup

> **Note:** Configuration assumes a device with its default settings.

- **Upstream connection:** "Port 0"
- **Dedicated control connection:** "Control"
- **Adequate power supply connection**
- **USB Device on a downstream port**

## Software Setup

1. Create a virtual environment:
   ```bash
   python -m venv venv
   ```

2. Activate the virtual environment:
   ```bash
   # macOS/Linux
   source venv/bin/activate
   
   # Windows
   venv\Scripts\activate
   ```

3. Install BrainStem:
   ```bash
   pip install brainstem
   ```

## Example Usage

**Detailed Help:**
```bash
python speed_test_cli.py --help
```

**Automatic Mode:** Tests all ports which have a downstream device connected.
```bash
python speed_test_cli.py
```

**Manual Mode:** Tests all ports that are provided.
```bash
python speed_test_cli.py --test_ports 1 2 3
```

**Test a single port:**
```bash
python speed_test_cli.py --test_ports 3
```

**Connect to a specific device by serial number and perform automatic testing:**
```bash
python speed_test_cli.py --sn 0x12345678
```

## Exit Codes

| Code | Name | Description |
|------|------|-------------|
| 0 | SUCCESS | All speed tests passed |
| 1 | CONNECTION_ERROR | Failed to connect to device |
| 2 | CAPABILITY_CHECK_FAILED | Device does not support required capabilities |
| 3 | CONFIGURATION_ERROR | Failed to configure hub data rate settings |
| 4 | TEST_FAILED | One or more speed tests failed |

## Results Table

After testing, a summary table is printed showing PASS/FAIL/N/A for each port and speed configuration:

| Result | Meaning |
|--------|---------|
| PASS | Device enumerated at the expected speed |
| FAIL | Device did not enumerate at the expected speed |
| N/A | Configuration not supported by the device (not counted as failure) |

