import struct

def get_two_bytes_from_buffer(buffer, offset=0):
    if isinstance(buffer, list):
        buffer = bytearray(buffer)
    return struct.unpack_from('<H', buffer, offset)[0]

def get_four_bytes_from_buffer(buffer, offset=0):
    if isinstance(buffer, list):
        buffer = bytearray(buffer)
    return struct.unpack_from('<I', buffer, offset)[0]

def get_two_byte_list_from_buffer(buffer, start_offset=0, end_offset=None):
    end_offset = end_offset or len(buffer)
    return [get_two_bytes_from_buffer(buffer, x) for x in range(start_offset, end_offset, 2)]

#Converts a list of 2 byte (short) values to a list of strings in hex format. Pretty printing. 
def format_list_as_hex_string_list(list, width=4):
    return [("0x{:0{width}X}".format(element, width=width)) for element in list]


