/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: BrainStem-C.h                                             //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// description: BrainStem API's and support.                       //
//                                                                 //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2018 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef _BrainStem2_H_
#define _BrainStem2_H_

/////////////////////////////////////////////////////////////////////
/// All inclusive Header for C-API access.

/**
 * This file can be included by users of the C-API and includes all of
 * the necessary header files which represent the C-API.
 */

/////////////////////////////////////////////////////////////////////
/// Cross platform defines and system includes.
#include "aDefs.h"

/////////////////////////////////////////////////////////////////////
/// Filesystem interaction.
#include "aDirectory.h"

/////////////////////////////////////////////////////////////////////
/// BrainStem discovery functions for USB and TCPIP based
#include "aDiscover.h"

/////////////////////////////////////////////////////////////////////
/// BrainStem Error Codes.
#include "aError.h"

/////////////////////////////////////////////////////////////////////
/// Filesystem interaction, CRUD access.
#include "aFile.h"

/////////////////////////////////////////////////////////////////////
/// Link to BrainStem.
#include "aLink.h"

/////////////////////////////////////////////////////////////////////
/// Logging
#include "aLogger.h"

/////////////////////////////////////////////////////////////////////
/// Thread synchronization primitive.
#include "aMutex.h"

/////////////////////////////////////////////////////////////////////
/// Packet structure and accessors.
#include "aPacket.h"

/////////////////////////////////////////////////////////////////////
/// Specific persistent enumerations
#include "aProtocoldefs.h"

/////////////////////////////////////////////////////////////////////
/// Networking
#include "aSocket.h"

/////////////////////////////////////////////////////////////////////
/// Stream Access, Read and Write.
#include "aStream.h"

/////////////////////////////////////////////////////////////////////
/// Sleep and Timer functions.
#include "aTime.h"

/////////////////////////////////////////////////////////////////////
/// UEI functions.
#include "aUEI.h"

/////////////////////////////////////////////////////////////////////
/// Version functions
#include "aVersion.h"

/////////////////////////////////////////////////////////////////////
/// Device Port Mapping
#include "PortMapping.h"

#ifdef __cplusplus
extern "C" {
#endif

    //Libusb is used in multiple places within the BrainStem framework:
    // - aLink_CreateUSB -> aLink.h (Called during USB Module object creation)
    // - getDownstreamDevices() -> PortMapping.h
    // - USB discovery -> aDiscovery.h
    //These functions execute "libusb_init" and "libusb_exit" as needed.
    //Calling these functions from different threads can result in race conditions.
    //If your application is known to do this it is recommended to add these to
    //the entry and exit points of your "main" application.

    //Globally initializes libusb memory for the current process.
    aLIBEXPORT void BrainStem_libusb_init(void);

    //Globally de-initializes libusb memory for the current process.
    aLIBEXPORT void BrainStem_libusb_exit(void);


#ifdef __cplusplus
}
#endif

#endif //_BrainStem2_H_
